/* Driver for routines KS and CYFUN in file DESKS.C */

#include <stdio.h>
#include "nr.h"
#include "nrutil.h"

unsigned long bit[33];

main()
{
	int i,k,l,m;
	char txt[65];
	unsigned long iout,ir;
	immense key;
	great kn;

	bit[1]=1;
	for (i=2;i<=32;i++) bit[i]=bit[i-1] << 1;
	/* Test routine KS */
	key.l=key.r=0x55555555L;
	for (i=1;i<=64;i++) txt[i]= i%2 ? '*' : '-';
	printf("legend:\n%25s\n","-=0   *=1 ");
	printf("master key:\n             ");
	for (i=1;i<=64;i++) printf("%1c",txt[i]);
	printf("\nsub-master keys:\n");
	for (i=1;i<=16;i++) {
		ks(key,i,&kn);
		for (k=1,l=17,m=33;k<=16;k++,l++,m++) {
			txt[k]=kn.r & bit[k] ? '*' : '-';
			txt[l]=kn.c & bit[k] ? '*' : '-';
			txt[m]=kn.l & bit[k] ? '*' : '-';
		}
		printf("%6d %6s",i," ");
		for (k=1;k<=48;k++) printf("%1c",txt[k]);
		printf("\n");
	}
	printf("Press RETURN to continue...\n");
	getchar();
	/* Test routine CYFUN */
	ir=0x49249249L;
	for (i=1;i<=32;i++)
		txt[i]=(i%3)%2 ? '*' : '-';
	printf("legend:\n%25s\n","-=0   *=1 ");
	printf("input to cipher function:\n             ");
	for (i=1;i<=32;i++) printf("%1c",txt[i]);
	printf("\nciphered output:\n");
	for (i=1;i<=16;i++) {
		ks(key,i,&kn);
		cyfun(ir,kn,&iout);
		for (k=1;k<=32;k++) txt[k]=iout & bit[k] ? '*' : '-';
		printf("%6d %6s",i," ");
		for (k=1;k<=32;k++) printf("%1c",txt[k]);
		printf("\n");
	}
}
