/* Driver for routine BSSTEP */

#include <stdio.h>
#include <math.h>
#include "nr.h"
#include "nrutil.h"

#define N 4
#define IMAX 11
#define NUSE 7

void derivs(x,y,dydx)
float x,y[],dydx[];
{
   dydx[1] = -y[2];
   dydx[2]=y[1]-(1.0/x)*y[2];
   dydx[3]=y[2]-(2.0/x)*y[3];
   dydx[4]=y[3]-(3.0/x)*y[4];
}

main()
{
	int i;
	float eps,hdid,hnext,htry,x=1.0,*y,*dydx,*yscal;

	y=vector(1,N);
	dydx=vector(1,N);
	yscal=vector(1,N);
	y[1]=bessj0(x);
	y[2]=bessj1(x);
	y[3]=bessj(2,x);
	y[4]=bessj(3,x);
	dydx[1] = -y[2];
	dydx[2]=y[1]-y[2];
	dydx[3]=y[2]-2.0*y[3];
	dydx[4]=y[3]-3.0*y[4];
	for (i=1;i<=N;i++) yscal[i]=1.0;
	htry=1.0;
	printf("\n%10s %10s %12s %12s \n","eps","htry","hdid","hnext");
	for (i=1;i<=15;i++) {
		eps=exp((double) -i);
		bsstep(y,dydx,N,&x,htry,eps,yscal,&hdid,&hnext,derivs);
		printf(" %11f %8.2f %14.6f %12.6f\n",eps,htry,hdid,hnext);
	}
	free_vector(yscal,1,N);
	free_vector(dydx,1,N);
	free_vector(y,1,N);
}
