/* Driver for routine ADI */

#include <stdio.h>
#include <math.h>
#include "nr.h"
#include "nrutil.h"

#define JMAX 11
#define PI 3.1415926

main()
{
	int i,j,k,mid,twotok;
	double alim,alpha,beta,eps;
	double **a,**b,**c,**d,**e,**f,**g,**u;

	a=dmatrix(1,JMAX,1,JMAX);
	b=dmatrix(1,JMAX,1,JMAX);
	c=dmatrix(1,JMAX,1,JMAX);
	d=dmatrix(1,JMAX,1,JMAX);
	e=dmatrix(1,JMAX,1,JMAX);
	f=dmatrix(1,JMAX,1,JMAX);
	g=dmatrix(1,JMAX,1,JMAX);
	u=dmatrix(1,JMAX,1,JMAX);
	for (i=1;i<=JMAX;i++) {
		for (j=1;j<=JMAX;j++) {
			a[i][j] = -1.0;
			b[i][j]=2.0;
			c[i][j] = -1.0;
			d[i][j] = -1.0;
			e[i][j]=2.0;
			f[i][j] = -1.0;
			g[i][j]=0.0;
			u[i][j]=0.0;
		}
	}
	mid=JMAX/2+1;
	g[mid][mid]=2.0;
	alpha=2.0*(1.0-cos(PI/JMAX));
	beta=2.0*(1.0-cos((JMAX-1)*PI/JMAX));
	alim=log(4.0*JMAX/PI);
	k=0;
	twotok=1;
	while (twotok < alim) {
		++k;
		twotok *= 2;
	}
	eps=1.0e-4;
	adi(a,b,c,d,e,f,g,u,JMAX,k,alpha,beta,eps);
	printf("ADI Solution:\n");
	for (i=1;i<=JMAX;i++) {
		for (j=1;j<=JMAX;j++) printf("%7.2f",u[i][j]);
		printf("\n");
	}
	printf("\nTest that solution satisfies difference eqns:\n");
	for (i=2;i<=JMAX-1;i++) {
		for (j=2;j<=JMAX-1;j++)
			g[i][j] = -4.0*u[i][j]+u[i+1][j]
				+u[i-1][j]+u[i][j-1]+u[i][j+1];
		printf("       ");
		for (j=2;j<=JMAX-1;j++) printf("%7.2f",g[i][j]);
		printf("\n");
	}
	free_dmatrix(u,1,JMAX,1,JMAX);
	free_dmatrix(g,1,JMAX,1,JMAX);
	free_dmatrix(f,1,JMAX,1,JMAX);
	free_dmatrix(e,1,JMAX,1,JMAX);
	free_dmatrix(d,1,JMAX,1,JMAX);
	free_dmatrix(c,1,JMAX,1,JMAX);
	free_dmatrix(b,1,JMAX,1,JMAX);
	free_dmatrix(a,1,JMAX,1,JMAX);
}
