/* Driver for routine GAMDEV */

#include <stdio.h>
#include "nr.h"

#define N 20
#define NPTS 2000
#define ISCAL 200
#define LLEN 50

main()
{
	char words[LLEN+1];
	int i,ia,idum=(-13),j,k,klim,dist[N+1];
	float dd;

	for (;;) {
		for (j=0;j<=N;j++) dist[j]=0;
		do {
			printf("Select order of Gamma distribution (n=1..%d), -1 to end\n",N);
			scanf("%d",&ia);
		} while (ia > N);
		if (ia < 0) break;
		for (i=1;i<=NPTS;i++) {
			j=gamdev(ia,&idum);
			if ((j >= 0) && (j <= N)) ++dist[j];
		}
		printf("\ngamma-distribution deviate, order %2d of %6d points\n",
			ia,NPTS);
		printf("%6s %7s %9s \n","x","p(x)","graph:");
		for (j=0;j<N;j++) {
			dd=(float) dist[j]/NPTS;
			for (k=1;k<=50;k++) words[k]=' ';
			klim=ISCAL*dd;
			if (klim > LLEN) klim=LLEN;
			for (k=1;k<=klim;k++) words[k]='*';
			printf("%6d %8.4f  ",j,dd);
			for (k=1;k<=klim;k++) printf("%c",words[k]);
			printf("\n");
		}
	}
}
