/* User interface routines for 3DVIEW */

/* Written by Bernie Roehl, January 1992 (broehl@sunee.waterloo.edu) */

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

#include <stdio.h>
#include <ctype.h>
#include "../include/rend386.h"
#include "../include/userint.h"
#include "../include/pointer.h"
#include "../include/cursor.h"

/* Colors */
#define INTERIOR   4
#define TEXT      14

#define TEXTHEIGHT 8
#define TEXTWIDTH 8

extern int left_page, right_page;
extern PDRIVER *menu_device;

void neatbox(int w, int h, int *x, int *y)
{
	extern int v_page;
	*x = (screeninfo->xcent - (w >> 1)) & 0x0FF8;
	*y = screeninfo->ycent - (h >> 1);
	right_page = left_page = v_page; /* stop stereo for now */
	user_box(*x-2, *y-2, *x+w+8, *y+h+8, 0);
	user_box(*x-5, *y-5, *x+w+5, *y+h+5, INTERIOR);
}

void poptext(char *text[])
{
	int i, h = 0, w = 0, x, y, page;
	page = cursor_hide();
	for (i = 0; text[i]; ++i) {
		h += TEXTHEIGHT;
		if (strlen(text[i])*TEXTWIDTH > w)
			w = strlen(text[i])*TEXTWIDTH;
	}
	if (w > 300) w = 300;
	neatbox(w , h , &x, &y);
	for (i = 0; text[i]; ++i) {
		user_text(x, y, TEXT, text[i]);
		y += TEXTHEIGHT;
	}
	cursor_show(page);
}

int menu(char *text[]) /* returns number (0--n) of entry clicked on */
{
	int i, h = 0, w = 0, x, y, page;
	int top;
	unsigned buttons;
	int num = 0;
	page = cursor_hide();
	for (i = 0; text[i]; ++i)
	{
		h += TEXTHEIGHT;
		if (strlen(text[i])*TEXTWIDTH > w)
			w = strlen(text[i])*TEXTWIDTH;
	}
	if (w > 300) w = 300;
	neatbox(w, h, &x, &y);
	top = y;
	for (i = 0; text[i]; ++i)
	{
		user_text(x, y, TEXT, text[i]);
		y += TEXTHEIGHT;
		num++;
	}
	cursor_show(page);
	do {
		while (move_2D(menu_device, &x, &y, &buttons) == 0);
		do { 
			move_2D(menu_device,&x, &y, &buttons); 
		}
		while (!buttons);
		do { 
			move_2D(menu_device,&x, &y, &buttons); 
		}
		while (buttons);
		i = (y-top) / TEXTHEIGHT;
	}
	while ((i < 0) || (i >= num));
	return(i);
}

void popmsg(char *msg)
{
	int x, y, page;
	page = cursor_hide();
	neatbox(strlen(msg)*TEXTWIDTH+16, TEXTHEIGHT+16, &x, &y);
	user_text(x+8, y+8, TEXT, msg);
	cursor_show(page);
}

unsigned askfor(char *prompt, char *buff, int n)
{
	unsigned c, page;
	int x, y, i;

	page = cursor_hide();
	neatbox(strlen(prompt)*TEXTWIDTH + n * TEXTWIDTH + 10,
	TEXTHEIGHT + 10, &x, &y);
	user_text(x, y, TEXT, prompt);
	x += strlen(prompt) * TEXTWIDTH;
	buff[i = 0] = '\0';
	while ((c = getkey()) != 0x1B)
	{
		if (c == '\r') break;
		if (c == '\b' && i > 0)
		{
			user_box(x, y, x+TEXTWIDTH*strlen(buff), y+TEXTHEIGHT, INTERIOR);
			buff[--i] = '\0';
			user_text(x, y, TEXT,buff);
		}
		if (isprint(c) && i < n)
		{
			buff[i++] = c;
			buff[i] = '\0';
			user_text(x, y, TEXT, buff);
		}
	}
	cursor_show(page);
	return c;
}
