/****************************************************************************/
/*                                                                          */
/*    PTRTEST.C - Test program for printer ports.                           */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                Copyright 1990, Diebold, Incorporated                     */
/*                                                                          */
/*                                             last date mod ==>  05/11/90  */
/*                                                                          */
/*1 Functions: main, testptr                                                */
/*1                                                                         */
/*                                                                          */
/*7 Author: Brad Stephenson     DATE:  05/11/90                             */
/*                                                                          */
/*8 Revision:                                                               */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include <dos.h>
#include <stdlib.h>                 /* for isdigit()                       */
#include <conio.h>                  /* for clrscr()                        */
#include <ctype.h>                  /* for isdigit()                       */
#include <bios.h>                   /* for biosprt()                       */

#define DOS_FLUSH_THEN_GETKEY 0x0C
#define ONE   0x01
#define NUL   0x00
#define PRTCH 0x00
#define STAT  0x02

union REGS regs;                    /* 80xxx micro registers for DOS calls */

char ptrname[2][5] = {"LPT1","LPT2"};

int digit,status,port,p;

void testptr(int port, int testnum);

void main(int argc, char *argv[])
    {
    if (argc>1)
        {
        if ( (*argv[1] != '1') && (*argv[1] != '2') )
            {
            fprintf(stderr,"\nInvalid printer port.  Usage:  LPTEST [1|2]\n");
            exit(1);
            }
        else
            {
            port = atoi(argv[1]);
            }
        }
     else
        {
        port=1;
        }

    clrscr();
    fprintf(stderr,"\n\n   This program displays the status of the "
                   "printer port under various error\r\n"
                   "   conditions.  If you would like the results stored "
                   "in a disk file, use DOS\n"
                   "   redirection when calling this program.\n"
                   "\n     For example:  LPTEST >output.fil\n\n");

    fprintf(stderr,"   To test LPT2, use:   LPTEST 2\n\n");

    fprintf(stderr,"\n1."
    " Turn your printer on, make sure it has paper and is on-line.\n"
    "   Press the Return key when ready...");
    regs.h.ah = DOS_FLUSH_THEN_GETKEY;
    regs.h.al = ONE;
    digit=intdos(&regs,&regs);
    testptr(port-1,0);

    fprintf(stderr,"\n\n2."
    " Make your printer go off-line (press the ON-LINE button once).\n"
    "   Press the Return key when ready...");
    regs.h.ah = DOS_FLUSH_THEN_GETKEY;
    regs.h.al = ONE;
    digit=intdos(&regs,&regs);
    testptr(port-1,1);

    fprintf(stderr,"\n\n3."
    " Place your printer on-line, then remove the paper from the printer.\n"
    "   Press the Return key when ready...");
    regs.h.ah = DOS_FLUSH_THEN_GETKEY;
    regs.h.al = ONE;
    digit=intdos(&regs,&regs);
    testptr(port-1,2);

    fprintf(stderr,"\n\n4."
    " Turn the printer's power switch off.\n"
    "   Press the Return key when ready...");
    regs.h.ah = DOS_FLUSH_THEN_GETKEY;
    regs.h.al = ONE;
    digit=intdos(&regs,&regs);
    testptr(port-1,3);

    fprintf(stderr,"\n\n5."
    " Disconnect the data cable going to the printer.\n"
    "   Press the Return key when ready...");
    regs.h.ah = DOS_FLUSH_THEN_GETKEY;
    regs.h.al = ONE;
    digit=intdos(&regs,&regs);
    testptr(port-1,4);
    }


/***************************** D I E B O L D ********************************
 *
 *1  FUNCTION:  testptr
 *
 *2  SUMMARY:  This function tests the printer port to see if it is ready
 *
 *3  INVOCATION: void testptr(ptrport,test)
 *
 *4  INPUTS:  Printer port to be tested, Test number
 *
 *5  OUTPUTS: Displays the results of the three tests; can be redirected.
 *
 *6  CAVEATS:
 *
 *7  AUTHOR: Brad Stephenson     DATE:  05/11/90 
 *
 *8  REVISION:
 *
 ****************************************************************************/

void testptr(int ptrport, int test)

    {

    printf("\n\n   Status of %s port when ",ptrname[ptrport]);

    switch(test)
        {
        case 0:
            {
            printf("printer is ready and has paper:\n");
            break;
            }
        case 1:
            {
            printf("printer is off-line:\n");
            break;
            }
        case 2:
            {
            printf("printer is out of paper:\n");
            break;
            }
        case 3:
            {
            printf("printer is powered off:    \n");
            break;
            }
        case 4:
            {
            printf("no printer is attached:\n");
            break;
            }
        default:
            {
            break;
            }
        }
    
    printf("      Initial status : %02X\n",biosprint(STAT,NUL,ptrport) );
    printf("      Printing NULL  : %02X\n",biosprint(PRTCH,NUL,ptrport) );
    printf("      Trailing status: %02X\n",biosprint(STAT,NUL,ptrport) );

    }

