#ifndef __PROPERTY_TAB
#define __PROPERTY_TAB

#define MAXROWS				20

// =========================================================
// TPropertyEntry
//
// holder class for page information
// =========================================================
class TPropertyEntry
{
	string			sTabText;
	TPropertyPage	*pPage;
	int				nWidth;
	BOOL			bEnabled;

public:
	TPropertyEntry ();
	TPropertyEntry (string sTabText, TPropertyPage *pPage, BOOL bEnabled = TRUE);

	TPropertyEntry&	operator= (const TPropertyEntry&);
	BOOL			operator== (const TPropertyEntry&);

	string&			GetText ()			{ return sTabText; }
	TPropertyPage	*GetDialog ()		{ return pPage; }
	int				GetWidth ()			{ return nWidth; }
	void			SetWidth (int n)	{ nWidth = n; }
	BOOL			IsEnabled ()		{ return bEnabled; }
	void			EnableTab (BOOL b)	{ bEnabled = b; }
};

typedef TArrayAsVector<TPropertyEntry>		TPropertyArray;

class TRange
{
public:
	int		Left;
	int		Right;
};

// =========================================================
// TPropertyTab
//
// class which handles drawing and switching of pages
// =========================================================
class TPropertyTab : public TControl
{
	TPropertyArray	pages;
	TFont			*pfontNormal;
	TFont			*pfontSelect;
	TPen			*ppenActive;

	int				nSelect;
	Tab::Style 		styleTabs;

	// tab/area size parameters
	int				nTabHeight;
	int				nTextHeight;
	int				nFixedTabWidth;
	int				nWideMarginWidth;
	TRect			rcSize;

	// variables for stacked tabs
	int				nRows;
	TRange			ptRanges[MAXROWS];
	int				nRowOrder[MAXROWS];

	// variables for scrolling
	int				nTabOrigin;
	BOOL			bLeftScroll;
	BOOL			bRightScroll;
	int				xMax;
	TBitmap			*bmpLeftArrow;
	TBitmap			*bmpRightArrow;

	// system colors
	TColor			colorWhite;
	TColor			colorLtGray;
	TColor			colorDkGray;
	TColor			colorBlack;

	BOOL 			AdjustOrigin (int nTab);
	void 			DrawTab (TDC& dc, int& x, int nTab, int yParam = 0, BOOL bIsLast = TRUE);
	void			DrawTabs (TDC& dc);
	void			DrawStackedTabs (TDC& dc);
	int				GetLastTab (BOOL bVisible);
	int 			GetMouseTab (TPoint& point);
	BOOL 			GetTabRect (TRect& rc, int nTab, int nOrigin = -1);
	int				GetTabRow (int nTab);
	int				GetTabWidth (int nTab)				{ return pages[nTab].GetWidth (); }
	int				CalcTabWidth (TDC& dc, int nTab);
	void			CalculateTabWidths ();
	void			CalculateBasicTabWidths ();
	void			ReassessTabWidths ();

	// scrolling functions
	BOOL			AssessScroll ();
	void 			GetScrollRect (TRect& rcTabs, int nButton = -1);
	void			NextOrigin (int nDir = 1);

	void 			SetRect (TRect& rc, int nRow = -1);
	void			SetPageFocus ();

	void 			EvLButtonDown(UINT modKeys, TPoint& point);

public:
	TPropertyTab (TWindow *pParent, Tab::Style style);
	virtual ~TPropertyTab ();

	void			SetupWindow ();
	void			Paint (TDC& dc, BOOL erase, TRect& rc);
	void			EvSize (UINT, TSize& size);
	void 			TabColorChange ();

	void			EvSetFocus (HWND hwndLostFocus);
	void			EvKillFocus (HWND hwndGetFocus);
	void			EvKeyDown (UINT key, UINT repeatCount, UINT flags);
	UINT			EvGetDlgCode (MSG far *);

	LPSTR			GetClassName ();
	void			GetWindowClass (WNDCLASS& wc);

	void			Add (LPCSTR lpszTab, TPropertyPage *pPage, BOOL bEnabled = TRUE);
	void			DestroyPages ();

	int				GetEntryCount ()		{ return pages.GetItemsInContainer (); }
	TPropertyPage 	*GetPage (int n)		{ return pages[n].GetDialog (); }
	int				GetSelectedTab ()		{ return nSelect; }
	Tab::Style		GetTabStyle ()			{ return styleTabs; }

	BOOL			SavePageData ();

	void 			SelectTab (int nTab);
	void			SelectNext (int nDir = 1);
	BOOL			SelectTabByKey (char cKey);

	BOOL 			IsTabEnabled (int nTab);
	BOOL 			IsTabSelected (int nTab);
	BOOL 			IsTabVisible (int nTab);

	void 			EnableTab (int nTab, BOOL bEnable);
	void 			SetActiveColor (TColor color);
	void 			SetFixedTabWidth (int nWidth);
	void 			SetWideMarginWidth (int nWidth);

	DECLARE_RESPONSE_TABLE(TPropertyTab);
};

#endif