#if !defined(__PRINTQ_H)
#define __PRINTQ_H

class PrintJob
	{
	public:

		PrintJob(int aPrintSize);
		virtual ~PrintJob();

		virtual void reset();
		virtual int getText(char*&);
		virtual void skip(int);
		virtual Boolean complete();
		long amountPrinted()
			{	return pos;	}
		long amountRemaining()
			{	return size-pos; }

	protected:

		long pos;
		long size;
		int printSize;
	};

inline PrintJob::PrintJob(int aPrintSize) :
		pos(0), size(0), printSize(aPrintSize)
	{}

inline PrintJob::~PrintJob()
	{}

inline void PrintJob::reset()
	{ pos = 0; }

inline int PrintJob::getText(char*& buf)
	{ buf = 0;  return 0; }

inline void PrintJob::skip(int n)
	{
	pos += n;
	if(pos > size)
		pos = size;
	}

inline Boolean PrintJob::complete()
	{ return Boolean(pos >= size); }

// ------------------------------------------------------------------

const int PQDelta = 4;
const int PQMaxSize = int((65536UL - 16)/sizeof(PrintJob*));

class PrintQueue
	{
	public:

		PrintQueue();
		virtual ~PrintQueue();

		Boolean insert(PrintJob*);
		Boolean kill(PrintJob*);
		void killAll();
		PrintJob* currentJob() const;
		Boolean print();

	protected:

		virtual int printString(const char*, int) const = 0;
		virtual Boolean printFormFeed() const;

		Boolean setJobsSize(int);

		PrintJob** jobs;
		int count;
		int limit;
	};

inline PrintQueue::PrintQueue() : jobs(0), count(0), limit(0)
	{}

inline PrintQueue::~PrintQueue()
	{
	killAll();
	}

inline PrintJob* PrintQueue::currentJob() const
	{
	if(count > 0)
		return jobs[0];
	else
		return 0;
	}

inline Boolean PrintQueue::printFormFeed() const
	{
	return Boolean(printString("\f",1) == 1);
	}

// ------------------------------------------------------------------
// Some standard PrintJobs.

// Print a contiguous buffer.

class PrintBuffer : public PrintJob
	{
	public:

		PrintBuffer(char*, long, int);
		virtual ~PrintBuffer();

		virtual int getText(char*&);

	protected:

		char* buffer;
	};

inline PrintBuffer::PrintBuffer(char* aBuffer, long aSize, int aPrintSize) :
		PrintJob(aPrintSize),
		buffer(aBuffer)
	{
	size = aSize;
	}

inline PrintBuffer::~PrintBuffer()
	{
	delete [] buffer;
	}

inline int PrintBuffer::getText(char*& buf)
	{
	if(complete())
		{
		buf = 0;
		return 0;
		}
	else
		{
		buf = buffer+pos;
		int len = printSize;
		if(pos+len > size)
			len = int(size-pos);
		return len;
		}
	}

// Print a file.

class PrintFile : public PrintJob
	{
	public:

		PrintFile(const char*, int);
		virtual ~PrintFile();

		virtual int getText(char*&);

	protected:

		int handle;
		char* buffer;
	};

#endif	// __PRINTQ_H
