/********************************************************************
        PopASC  (c) Copyright 1992-94 by Omega Point, Inc.
*********************************************************************/


#include "cr.h"


/***********************************************************
	RESIDENT VARIABLES & DEFINITIONS
************************************************************/

extern word _hkey_again; /* Set to NZ if another hot-key hit. */

#define MOVABLE_WINDOW (0)	/* Set to 1 if window movable */
#define DX1 (7)
#define DY (18)
#define NC (4)
#define DX (NC*DX1+1)
#define DXC (4*8+2)
#define BLK_SZ (DXC*DY)
#define MAX_PG (16)

word saved_scr[BLK_SZ];	/* Keep foreground screen here */

int x0=16,y0=4;		/* Box position */
int sdx=DX,sdy=DY;
int cur_page;
int sel_let,sel_x=0,sel_y=0;
int pref_let='P'-0x40;
int max_x,max_y;
char pref_on=0,color_chart=0;

byte atr_fram=0x19,atr_dec=0x1b,atr_hex=0x1b,sel_atr=0x4e;
byte atr_txt[]={0x1e,0x1f};

/* Last ASCII page - graphics characters in logical order */

byte gc[64]={\
g1_c1,g1_t4,g1_c4, g2_c1,g2_t4,g2_c4, g21_c1,g21_t4,g21_c4, g12_c1,g12_t4,g12_c4,
0xfe,0xb0,0x07,0xf9,
g1_t1,g1_cr,g1_t3, g2_t1,g2_cr,g2_t3, g21_t1,g21_cr,g21_t3, g12_t1,g12_cr,g12_t3,
0x16,0xb1,0x04,0xdc,
g1_c2,g1_t2,g1_c3, g2_c2,g2_t2,g2_c3, g21_c2,g21_t2,g21_c3, g12_c2,g12_t2,g12_c3,
0xae,0xb2,0xf0,0xdf,
g1_ver,g1_hor,g2_ver,g2_hor, 0x11,0x10,0x1e,0x1f, 0x1b,0x1a,0x18,0x19,
0xaf,0xdd,0xde,0xdb};

#define TOP_FR (0xdb)
#define BOT_FR (0xdb)

char tmp[5]="1234";

send_key()
{
  if (pref_on)
    stuff_key(pref_let);
    stuff_key(sel_let);
}

/* Show COLOR CHART */

show_colors()
{ register char *s=tmp+1;
  int m,i,j,xs;
    *((dword*)tmp)=0x20202020L; m=0;
    xs=x0-4+1;
    for (j=0; j<8; j++)
      {
      xs+= 4; crs_y=y0;
      for (i=0; i<16; i++,m++)
	{
        crs_x=xs; crs_y++;
	vid_atr=m;
	b2hex(m,s); dsp(s-1);
	}
      }
}

show_sel()
{ int i;
  crs_x=sel_x*DX1+x0+4;
  crs_y=sel_y+y0+1;
  hor_atr(3);
  i=((sel_x<<4)|sel_y)&0xff;
  if (cur_page==MAX_PG) sel_let=gc[i];
    else sel_let=(cur_page<<4)|i;
}

mov_sel(dx,dy)
{
   if (color_chart) return;
   vid_atr=atr_txt[sel_x&1];
   show_sel();
   sel_x+=dx; 
   if (sel_x>=NC) sel_x=0;
	else if (sel_x<0) sel_x=NC-1;
   sel_y+=dy;
   if (sel_y>=16) sel_y=0;
	else if (sel_y<0) sel_y=15;
}

show_frame()
{ int i,j;
   crs_x=x0; crs_y=y0;
   vid_atr=atr_fram;

   if (color_chart)
     {
     dsp_box(DXC,DY,'');
     return;
     }

   dsp_hor(TOP_FR,DX);
   for (i=0,crs_y++,crs_x=x0; i<16;i++)
     {
     dsp("");
     for (j=0; j<NC; j++) dsp("     ");
     crs_x--;dsp(""); 
     crs_x=x0; crs_y++;
     }
   dsp_hor(BOT_FR,DX);

 }

/*** SHOW ASCII CHART ***/

show_page()
{
  int i,c,j,n1,n0,m,xs=x0+1,gr=0;
  register char *s=tmp;

     if (cur_page>MAX_PG) cur_page=0;
	else if (cur_page<0) cur_page=MAX_PG;

     if (cur_page<MAX_PG) m=(cur_page/NC)*NC;
	else {m=0; gr=1;}

     if (color_chart)
	{
	show_colors();
	return;
	}

     for (j=0; j<NC; j++)
       {
       n0=((m+j)<<4);
       n1=n0+16;
       crs_y=y0+1;
       for (i=n0; i<n1; i++)
	 {
	 crs_x=xs; vid_atr=atr_hex;
	 c = gr ? gc[i]:i;
	 b2hex(c,(char*)s); s[2]=0; dsp((char*)s);
	 crs_x+=2;
	 vid_atr=atr_txt[i&1];
	 dsp_chr(c); crs_y++;
	 }
       xs+=DX1;
       }
}

#if MOVABLE_WINDOW
move_pg(x1,y1)
{
    crs_x=x0; crs_y=y0;
    put_blk(sdx,sdy,saved_scr);
    crs_x=x1; crs_y=y1;
    get_blk(sdx,sdy,saved_scr);
    x0=x1; y0=y1;
    show_frame();
    show_page();
}
#endif


tog_col_chart()
{
  crs_x=x0; crs_y=y0;
  put_blk(sdx,sdy,saved_scr);
  color_chart^=1;
  if (! color_chart)
    {
    sdx=DX; sdy=DY;
    }
  else
    {
    sdx=DXC; sdy=DY;
    }
  set_max_xy();
  crs_x=x0; crs_y=y0;
  get_blk(sdx,sdy,saved_scr);
  show_frame();
}

full_key()
{ word k;
     while (!  anykey())
	if (_hkey_again)
	  {
	  _hkey_again=0;
	  return(-1);
	  }
      k=pckey(); 
      if (k<K_NUMPAD)
        if (k&0xff) 
	  {
	  k&=0xff;
	  if (k>='a')
	    if (k<='z') k-=0x20;
	  }
      return(k);
}

set_max_xy()
{
   max_x=scr_width-sdx;
   max_y=scr_len-sdy;
   if (x0>max_x) x0=max_x;
   if (y0>max_y) y0=max_y;
}

show_chart()
{  word k;

   show_frame(); /* Show ASCII chart frame & titles */   

   while (1) {

      show_page();	/* Show current page */
      if (!color_chart)
	{
        vid_atr=sel_atr;
        show_sel();
	}
      k=full_key(); 	
      switch (k) {
	case K_PGUP:	cur_page-=NC; break;
	case K_PGDN:	cur_page+=NC; break;
	case K_UP:	mov_sel(0,-1);break;
	case K_DN:	mov_sel(0,+1);break;
	case K_LEFT:	mov_sel(-1,0);break;
	case K_RIGHT:	mov_sel(+1,0);break;
	case K_HOME:	mov_sel(0,-3);break;
	case K_END:	mov_sel(0,+3);break;

/* -- Makes box movable with Shift-Cursor keys --*/

#if	MOVABLE_WINDOW

	case SK_UP:	move_pg(x0,y0>0?y0-1:max_y);
			break;
	case SK_DN:	move_pg(x0,y0<max_y?y0+1:0);
			break;
	case SK_LEFT:	move_pg(x0>0?x0-1:max_x,y0);
			break;
	case SK_RIGHT:	move_pg(x0<max_x?x0+1:0,y0);
			break;
#endif

	case 0x20:	tog_col_chart();
			break;
	case K_INS:	pref_on=1;send_key();
			return;
	case 0xd:	pref_on=0;
			send_key();
	case -1:
	case 0x1B:	return;
      }
   }
}

/** Save/Restore foreground screen **/

chg_scr(func)
fp func;
{
   crs_x=x0; crs_y=y0;
   (*func)(sdx,sdy,saved_scr);

}

/** RESIDENT CODE HOT-KEY LIST **/

word hk_list[]={K_RC,M_LC+0x39,SC_F12,M_LA+0x34,0};

/***********************************************************
    MAIN INTERRUPT SERVICE FUNCTION FOR HOT-KEYS
************************************************************/

isr(hk)
{
   if ((hk==hk_list[2])||(hk==hk_list[3])) send_key();
   else
     {
     _hkey_again=0;	/* Re-enable sensing of hot-key from within */
     chk_video();	/* Obtain screen width, cursor pos */
     set_max_xy();	/* Calculate box movement boundaries */
     chg_scr(get_blk);  /* Save foreground screen */
     show_chart();	/* Go display ASCII/Color chart */
     chg_scr(put_blk);	/* Restore foreground screen */
     }
}

