#ifndef __PXTBL_H
#define __PXTBL_H

#ifndef   __STRING_H
	#include <string.h>
#endif

#ifndef __STDARG_H
	#include <stdarg.h>
#endif

#ifndef   PXENGINE_H
	#include <pxengine.h>
#endif

#ifndef __BCD_H
	#include <bcd.h>
#endif

#ifndef   __STDLIB_H
	#include <stdlib.h>
#endif

#define LOCK 1

#include <owl\owlpch.h>
#include <owl\edit.h>

#ifndef __OWL_FLOATVAL_H
#include "floatval.h"
#endif

int pxError(int);

#define reqd TRUE
#define   CKERR   if (lastError) return (lastError)

class TPXTable;

class TPXValidator : public TLookupValidator {
	public:
		TPXTable *tbl;
		int error;

		TPXValidator(TPXTable *tbl, int error);

		virtual BOOL Lookup(const char far *str);
		void Error();
	};

// Abstract Field class
class TBaseFld {
	protected:
		FIELDHANDLE   hField;
		TPXTable*  pTbl;     // pointer to base table class
		int active;
		int required;
		TEdit *control;
		TValidator *validator;
	public:
		TBaseFld(TPXTable *parent, char *aName, int req = FALSE);
		~TBaseFld();

		int size;

		virtual int IsModified();
		virtual int CheckReqd(int onScr = FALSE) { return TRUE; }
		virtual void OnScreen(TWindow *parent, int id) {}
		virtual int	IsA() { return (0); }
		FIELDHANDLE FieldHandle() { return ( hField ); }
		virtual int Read() { return (-1); }
		virtual int Write(int = FALSE)  { return (-1); }
		virtual void Clear() {}
		int SearchField(RECORDHANDLE hRcrd, int mode, int readStatus = TRUE);
		virtual void MakeActive(int act = TRUE) { active = act; }
		virtual void OffScreen() {}
		virtual int Select();
		virtual int ReqdError(int good);
		virtual int Changed();
		char *name;
	};

// Character Field class
class TCharFld : public TBaseFld {
	protected:
		int Search(char *srchvar, int mode = SEARCHFIRST, int readStatus = TRUE);
		char *data;
	public:
		TCharFld (TPXTable *table, int size, char *name, int req = FALSE);
		~TCharFld();

		virtual void Strip(char *buff);
		virtual int IsBlank();
		virtual int CheckReqd(int onScr = FALSE);
		void  operator = (char *newval);
		void  operator = (TCharFld *newval);
		int IsA() { return (1); }
		void Clear();
		int Read();
		int Write(int = FALSE);
		virtual int Exact(char *srchvar = NULL, int readStatus = TRUE);
		int Generic(char *srchvar = NULL, int readStatus = TRUE);
		int Next(char *srchvar = NULL, int readStatus = TRUE);
		int FirstChar(char ch);
		char GetChar(int pos = 0);
		int GetText(char far *str);
		void SetText(char far *string);
		virtual void OnScreen(TWindow *parent,int resourceID);
		virtual void OnScreen(TEdit *aControl);
		virtual void OffScreen();
	};


// Short Field class
class TIntegerFld : public TBaseFld {
	private:
		int Search(short srchvar, int mode = 1, int readStatus = TRUE);
		short   data;
	public:
		TIntegerFld(TPXTable *table, int size, char *name, int req = FALSE);
		~TIntegerFld();

		virtual int CheckReqd(int onScr = FALSE) ;
		int IsA() { return (2); }
		operator short();
		operator >(int Compare);
		operator <(int Compare);
		void operator = (short newval);
		void operator = (TIntegerFld *newval);
		void Clear();
		int Read();
		int Write(int = FALSE);
		int Exact(short srchvar = 0, int readStatus = TRUE);
		int Generic(short srchvar = 0, int readStatus = TRUE);
		int Next(short srchvar = 0, int readStatus = TRUE);
		int GetText();
		void SetText(int val);
		virtual void OnScreen(TWindow *parent,int resourceID);
		virtual void OnScreen(TEdit *aControl);
		virtual void OffScreen();
	};

// Field class for DOUBLES
class TNumberFld : public TBaseFld {
	private:
		int Search(double srchvar, int mode = SEARCHFIRST, int readStatus = TRUE);
	public:
		bcd  data;
		TNumberFld(TPXTable *table, int size, int dec, char *name, int req = FALSE);
		~TNumberFld();

		int decimals;

		virtual int CheckReqd(int onScr = FALSE) ;
		int IsA() { return (3); }
		operator double();
		operator bcd();
		operator >(bcd Compare);
		operator <(bcd Compare);
		operator >(double Compare);
		operator <(double Compare);
		void operator = (double newval);
		void operator = (bcd newval);
		void operator = (TNumberFld *newval);
		void Clear();
		int Read();
		int Write(int = FALSE);
		int Exact(double srchvar = 0.0, int readStatus = TRUE);
		int Generic(double srchvar = 0.0, int readStatus = TRUE);
		int Next(double srchvar = 0.0, int readStatus = TRUE);
		void Inc(void);
		double GetText();
		bcd GetBcd();
		void SetText(double val);
		void SetText(bcd val);
		void OnScreen(TWindow *parent,int resourceID);
		virtual void OnScreen(TEdit *aControl);
		virtual void OffScreen();
	};

// Field class for DATES
class TDateFld : public TBaseFld {
	private:
		int Search(long srchvar, int mode = SEARCHFIRST, int readStatus = TRUE);
		long      data;
	public:
		TDateFld(TPXTable *table, char *name, int req = FALSE);
		~TDateFld();

		virtual int CheckReqd(int onScr = FALSE) ;
		int IsA() { return (4); }
		operator long();
		void operator = (char *);
		void operator = (long newval);
		void operator = (TDateFld *newval);
		void Clear();
		int Read();
		int Write(int = FALSE);
		int Exact(long srchvar = NULL, int readStatus = TRUE);
		int Generic(long srchvar = NULL, int readStatus = TRUE);
		int Next(long srchvar = NULL, int readStatus = TRUE);
		int Compare(TDateFld *dte);
		int Compare(long dte);
		int Month();
		int Day();
		int Year();
		long GetText();
		void SetText(long val);
		virtual void OnScreen(TWindow *parent,int resourceID);
		virtual void OnScreen(TEdit *aControl);
		virtual void OffScreen();
	};

// Base class for Table
class TPXTable{
	protected:
		int zeroBlanks;    // flag for zeros being written or blanks
		int nFlds;            // number of fields in the table
		int recLock;
		int active;

		virtual int InitFlds()   { return PXSUCCESS; }
		int SearchKey(int flds = 1, int mode = SEARCHFIRST, int readStatus = TRUE);
		int SearchComp(FIELDHANDLE hndl, int mode = SEARCHFIRST, int readStatus = TRUE);

	public:
		int	lastError;
		TBaseFld **pFlds;           // array of pointers to abstract field class
		char *tName;
		TABLEHANDLE   hTbl;
		RECORDHANDLE  hRcrd;
		LOCKHANDLE    hLock;
		int marker;        // flag for EOT or BOT
		int keyed;            // is this table keyed?

		TPXTable(char *name = NULL);
		~TPXTable();

		virtual void RetreiveData();
		int FldCount() { return nFlds; }
		int HandleEvent(int cmd);
		virtual void OnScreen(TWindow* parent, int firstID);
		virtual int ValidRecord(int onScr = FALSE);
		int Clear();
		void ClearFields();
		int Close();
		int Exact(int flds = 1, int readStatus = TRUE) { return SearchKey(flds,SEARCHFIRST,readStatus); }
		int Generic(int flds = 1, int readStatus = TRUE) { return SearchKey(flds,CLOSESTRECORD,readStatus); }
		int ExactComp(FIELDHANDLE hndl, int readStatus = TRUE) {
			return SearchComp(hndl,SEARCHFIRST,readStatus);
			}
		int GenericComp(FIELDHANDLE hndl, int readStatus = TRUE) {
			return SearchComp(hndl,CLOSESTRECORD,readStatus);
			}
		int Query(char *filename, FIELDHANDLE &hndl);
		int IsOpen() {return hTbl != 0;}
		int Open(int lock = FALSE, int onIndex = 0, char *name = NULL, int keymode = INCSECONDARY);
		int WriteFields();
		int AppendRecord();
		int InsertRecord();
		int UpdateRecord();
		int ReadFlds();
		int Read();
		int Erase();
		int Append();
		int ReadRecord();
		int Insert();
		int ActiveRecord() { return active; }
		void ClearRec() { active = FALSE; }
		void ClearAll() { active = FALSE; Clear(); }
		int DeleteRec(int msg = TRUE);
		int Next(int readStatus = TRUE);
		int Prev(int readStatus = TRUE);
		int Update();
		void OffScreen(int keepValues = FALSE);
		int Save(int msg = TRUE);
		void SetLock(int lock);
		int LockRecord();
		int UnlockRecord();
		int First(int readStatus = TRUE);
		int Last(int readStatus = TRUE);
		void MakeActive(int act = TRUE);
		FIELDHANDLE GetCompIndex(int cnt, ...);
		int Empty();
	};

int dateDecode(long date,int *month, int *day, int *year);

#define PXONSCREEN(px_tbl,fld) px_tbl->fld->OnScreen(fld);

class TPXTableListItem {
	private:
		TPXTable *tbl;

	public:
		TPXTableListItem *next;

		TPXTableListItem(TPXTable *aTbl) {
			tbl = aTbl;
			next = NULL;
			}
		~TPXTableListItem() {
			if (next != NULL) delete next;
			if (tbl->IsOpen()) {
				tbl->Close();
				}
			}
	};

class TPXTableList {
	private:
		TPXTableListItem *item;
		int count;

	public:
		TPXTableList() {
			item = NULL;
			count = 0;
			}
		~TPXTableList() {
			if (item != NULL) delete item;
			}
		virtual void AddItem(TPXTableListItem * aItem);
	};

class TPXEngine {
	private:
		TPXTableList *tables;

	public:
		TPXEngine() { tables = NULL; }
		~TPXEngine();

		int Init(char *client);
		void Insert(TPXTable *aTbl);
	};

#endif
