//=====================================================================
//
//  ioctl.cpp
//
//  Control device I/O
//
//  Protected Mode version
//
//  Copyright (c) 1994, Kevin Morgan, All rights reserved.
//
//=====================================================================

#pragma inline

#define __IN_IOCTL

#include <asmrules.h>
#include <io.h>
#include <_io.h>
#include <errno.h>
#include "dpmish.h"

int ioctl (int fd, int func, void *argdx, int argcx)
{
		struct DPMI_Regs iregs;
        struct DPMI_Regs *iregp = &iregs;
        iregp->eax = 0x4400 + func;
        iregp->ebx = fd;
		iregp->ecx = argcx;
		//
		// this next arg might be a problem
		// if it refers to a segment...
		// We'll assume it doesn't
		//
		iregp->edx = (unsigned long) argdx;

	    iregs.reserved = 0;
		iregs.flags = _FLAGS;
		//
		// might need to allocate a stack
	    //iregs.ss = dosMemory->dosseg;
	    //iregs.sp = dosMemory->dossp;
        iregs.ss = 0;
        iregs.sp = 0;
        Dpmi.simulateRealInterrupt(0x10, iregp);

        if (iregp->flags&1)
            return __IOerror(_AX);
        if (func==0)
            return iregp->edx;
        return iregp->eax;
}


