//---------------------------------------------------------------------------- 
// ObjectWindows - (C) Copyright 1993 by Borland International
//   source\owl\rangeval.cpp
//----------------------------------------------------------------------------
#pragma hdrignore SECTION
#include <owl\owlpch.h>
#include <owl\validate.h>
#include <owl\applicat.h>
#include <classlib\objstrm.h>

#if !defined(SECTION) || SECTION == 1
#include "floatval.h"

//
// TFloatValidator
//
TFloatValidator::TFloatValidator(int len, int dec, double min, double max) :
	TValidator() {
	Min = min;
	Max = max;
	if (dec) Length = len - dec - 2;
	else Length = len -1;
	Decimals = dec;
	}

void TFloatValidator::SetRange(double min, double max) {
	Min = min;
	Max = max;
	}

void TFloatValidator::Error() {
	char msg[81];
	wsprintf(msg, string(*GetApplicationObject(), IDS_VALNOTINRANGE).c_str(), Min, Max);
	::MessageBox(0, msg, GetApplicationObject()->GetName(),
		MB_ICONEXCLAMATION | MB_OK | MB_TASKMODAL);
	}

BOOL TFloatValidator::CheckNumber(const char far* s) {
	int retVal = TRUE;
	int i = strlen(s);
	if (!i) return TRUE;
	int j = 0;
	int dec = 0;
	int postDec = 0;
	int preDec = 0;
	while (j < i && retVal) {
		char ch = s[j];
		switch (ch) {
			case '-':
				if (j != 0) retVal = FALSE;
				preDec++;
				break;
			case '.':
				if (!dec) dec = 1;
				else retVal = FALSE;
				break;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				if (dec) {
					postDec++;
					if (postDec > Decimals) retVal = FALSE;
					}
				else {
					preDec++;
					if (preDec > Length) retVal = FALSE;
					}
				break;
			default:
				retVal = FALSE;
			}
		j++;
		}
	if (retVal == FALSE) MessageBeep(0);
	return retVal;
	}

BOOL TFloatValidator::IsValidInput(char far* s, BOOL) {
	return CheckNumber(s);
	}

BOOL TFloatValidator::IsValid(const char far* s) {
	if (*s && s != NULL) {
		double value = atof(s);
		if (CheckNumber(s)) {
			if (Min == Max) return TRUE;
			if (value >= Min && value <= Max) return TRUE;
			}
		return FALSE;
		}
	return TRUE;
	}

#endif
#if !defined(SECTION) || SECTION == 2

IMPLEMENT_STREAMABLE1(TFloatValidator, TValidator);

void* TFloatValidator::Streamer::Read(ipstream& is, uint32 ) const {
	ReadBaseObject((TValidator*)GetObject(), is);
	is >> GetObject()->Min >> GetObject()->Max >> GetObject()->Length >> GetObject()->Decimals;
  return GetObject();
	}

void
TFloatValidator::Streamer::Write(opstream& os) const {
	WriteBaseObject((TValidator*)GetObject(), os);
	os << GetObject()->Min << GetObject()->Max << GetObject()->Length << GetObject()->Decimals;
	}

//
// TIntValidator
//
TIntValidator::TIntValidator(int len, long min, long max) :
	TValidator() {
	Min = min;
	Max = max;
	Length = len -1;
	}

void TIntValidator::SetRange(long min, long max) {
	Min = min;
	Max = max;
	}

void TIntValidator::Error() {
	char msg[81];
	wsprintf(msg, string(*GetApplicationObject(), IDS_VALNOTINRANGE).c_str(), Min, Max);
	::MessageBox(0, msg, GetApplicationObject()->GetName(),
		MB_ICONEXCLAMATION | MB_OK | MB_TASKMODAL);
	}

BOOL TIntValidator::CheckNumber(const char far* s) {
	int retVal = TRUE;
	int i = strlen(s);
	if (!i) return TRUE;
	int j = 0;
	while (j < i && retVal) {
		char ch = s[j];
		switch (ch) {
			case '-':
				if (j != 0) retVal = FALSE;
				break;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				break;
			default:
				retVal = FALSE;
			}
		j++;
		}
	if (retVal == FALSE) MessageBeep(0);
	return retVal;
	}

BOOL TIntValidator::IsValidInput(char far* s, BOOL) {
	return CheckNumber(s);
	}

BOOL TIntValidator::IsValid(const char far* s) {
	if (*s && s != NULL) {
		long value = atol(s);
		if (CheckNumber(s)) {
			if (Min == Max) return TRUE;
			if (value >= Min && value <= Max) return TRUE;
			}
		return FALSE;
		}
	return TRUE;
	}

#endif
#if !defined(SECTION) || SECTION == 2

IMPLEMENT_STREAMABLE1(TIntValidator, TValidator);

void* TIntValidator::Streamer::Read(ipstream& is, uint32 ) const {
	ReadBaseObject((TValidator*)GetObject(), is);
	is >> GetObject()->Min >> GetObject()->Max >> GetObject()->Length;
  return GetObject();
	}

void
TIntValidator::Streamer::Write(opstream& os) const {
	WriteBaseObject((TValidator*)GetObject(), os);
	os << GetObject()->Min << GetObject()->Max << GetObject()->Length;
	}

//
// TDateValidator
//
TDateValidator::TDateValidator() : TValidator() {
	}

void TDateValidator::Error() {
	::MessageBox(0, "Invalid Date", GetApplicationObject()->GetName(),
		MB_ICONEXCLAMATION | MB_OK | MB_TASKMODAL);
	}

BOOL TDateValidator::CheckDate(const char far* s) {
	int retVal = TRUE;
	int i = strlen(s);
	if (!i) return TRUE;
	int j = 0;
	month = 0;
	day = 0;
	while (j < i && retVal) {
		char ch = s[j];
		switch (j) {
			case 0:
				if (ch != '0' && ch != '1') retVal = FALSE;
				else month = (ch == '0')?0:10;
				break;
			case 1:
				if (!isdigit(ch)) retVal = FALSE;
				else if (month == 0) {
					if (ch == '0') retVal = FALSE;
					}
				else {
					if (ch < '0' || ch > '2') retVal = FALSE;
					}
				if (retVal) month += ch - '0';
				break;
			case 2:
			case 5:
				if (ch != '/') retVal = FALSE;
				break;
			case 3:
				if (!isdigit(ch)) retVal = FALSE;
				else if (ch < '0') retVal = FALSE;
				else if (month == 2) {
					if (ch > '2') retVal = FALSE;
					}
				else if (ch > '3') retVal = FALSE;
				if (retVal) {
					switch (ch) {
						case '1':
							day = 10;
							break;
						case '2':
							day = 20;
							break;
						case '3':
							day = 30;
							break;
						}
					}
				break;
			case 4:
				if (!isdigit(ch)) retVal = FALSE;
				else if (day == 30) {
					if (ch > '1') retVal = FALSE;
					}
				else if (day == 0) {
					if (ch == '0') retVal = FALSE;
					}
				if (retVal) {
					day += ch - '0';
					switch (month) {
						case 1:
						case 3:
						case 5:
						case 7:
						case 8:
						case 10:
						case 12:
							if (day > 31) retVal = FALSE;
							break;
						case 2:
							if (day > 29) retVal = FALSE;
							break;
						case 4:
						case 6:
						case 9:
						case 11:
							if (day > 30) retVal = FALSE;
							break;
						}
					}
				break;
			case 6:
			case 7:
				if (!isdigit(ch)) retVal = FALSE;
				break;
			default:
				retVal = FALSE;
			}
		j++;
		}
	if (retVal == FALSE) MessageBeep(0);
	return retVal;
	}

BOOL TDateValidator::IsValidInput(char far* s, BOOL) {
	return CheckDate(s);
	}

BOOL TDateValidator::IsValid(const char far* s) {
	if (*s && s != NULL) {
		if (CheckDate(s)) {
			if (day == 29 && month == 2) {
				int year = (s[6] -'0') * 10 + s[7] - '0';
				if ((year % 4) == 0) return TRUE;
				}
			else return TRUE;
			}
		return FALSE;
		}
	return TRUE;
	}

#endif
#if !defined(SECTION) || SECTION == 2

IMPLEMENT_STREAMABLE1(TDateValidator, TValidator);

void* TDateValidator::Streamer::Read(ipstream& is, uint32 ) const {
	ReadBaseObject((TValidator*)GetObject(), is);
	return GetObject();
	}

void
TDateValidator::Streamer::Write(opstream& os) const {
	WriteBaseObject((TValidator*)GetObject(), os);
	}

#endif

