/*
** tone.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <conio.h>
#include "pictor.h"

/*
** Sounds the computer's internal speaker.
*/
void tone(int freq,int duration)
{
	int count,oldport;

	/* prevent divide-by-0 */
	if(freq == 0)
		return;

	outp(0x43,0xB6);
	count = (int)(1193180L / (long)freq);
	outp(0x42,count & 0xFF);
	outp(0x42,count >> 8);
	oldport = inp(0x61);
	outp(0x61,oldport | 0x03);
	pause(duration);
	outp(0x61,oldport);

} /* tone */
