/*
** statusbr.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include "pictor.h"

int _PL_statusrow = 25;
static int color = foreback(BLACK,WHITE);

/*
** Displays a message on the status bar.
*/
void statusbar(char *msg)
{
	vcolor(color);
	setvpos(_PL_statusrow,1);
	vputc(' ');
	vputs(msg);
	cleareol();

} /* statusbar */

/*
** Clears the status bar.
*/
void clrstatus(void)
{
	vcolor(color);
	setvpos(_PL_statusrow,1);
	vrepc(' ',_PL_columns);

} /* clrstatus */

/*
** Specifies the status bar row and colors.
*/
void initstatus(int row,int clr)
{
	_PL_statusrow = row;
	color = clr;
	clrstatus();
	
} /* initstatus */
