/*
** initvid.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <stdio.h>
#include <dos.h>
#include "pictor.h"


/*
** declare global video variables
*/
int _PL_segment = COLOR_SEG;
int _PL_offset = 0x0000;
int _PL_color = 0x07;
int _PL_snowcheck = FALSE;
int _PL_rows = 25;
int _PL_columns = 80;
int _PL_mode = 3;
int _PL_page = 0;
int _PL_colorsupport = FALSE;
int (*_PL_helpfunc)() = NULL;
char *_PL_helpcontext = NULL;


/*
** Initializes video variables.
*/
void initvideo(void)
{
	union REGS regs;

	/* get miscellaneous data */
	regs.h.ah = 0x0F;
	int86(0x10,&regs,&regs);
	_PL_mode = (int)regs.h.al;
	_PL_page = (int)regs.h.bh;
	_PL_columns = (int)regs.h.ah;

	/* determine color or mono emulation */
	int86(0x11,&regs,&regs);
	_PL_colorsupport = ((regs.x.ax & 0x30) == 0x30) ? FALSE : TRUE;

	/* get number of text rows */
	regs.h.ah = 0x12;
	regs.h.bl = 0x10;
	int86(0x10,&regs,&regs);

	if(regs.h.bl == 0x10 || _PL_colorsupport == (int)regs.h.bh) {
		/*
		** Function 0x12, subfunction 0x10 was not supported
		** or EGA/VGA was not the active display. Assume 25
		** rows, and set snow checking if color is supported.
		*/
		_PL_rows = 25;
		_PL_snowcheck = (_PL_colorsupport) ? TRUE : FALSE;
	}
	else {
		/*
		** Function 0x12, subfunction 0x10 was supported and
		** the EGA/VGA is the active display. Get the number
		** of textrows and disable snow checking on non-CGAs.
		*/
		regs.x.ax = 0x1130;
		int86(0x10,&regs,&regs);
		_PL_rows = ((int)regs.h.dl + 1);
		_PL_snowcheck = FALSE;
	}

	/* initialize screen address */
	_PL_segment = (_PL_colorsupport) ? COLOR_SEG : MONO_SEG;
	_PL_offset = 0x0000;

} /* initvideo */
