/*
** KBDSHIFT.C: Displays the state of the shift keys until
** the user presses <Escape>.
*/

#include <pictor.h>

char *labels[] = {
   "Right shift key down",
   "Left shift key down",
   "Ctrl-key down",
   "Alt key down",
   "Scroll Lock on",
   "Num Lock on",
   "Caps Lock on",
   "Insert on",
};

void main()
{
   int i,shiftstate;

   /* initialize library */
   initvideo();

   /* clear screen and hide cursor */
   cls();
   showcurs(FALSE);

   setvpos(10,1);
   vputs("Press <Escape> to end");

   while(!kbdready() || kbdread() != ESCAPE_KEY) {
      shiftstate = kbdshift();
      for(i = 0;i < 8;i++) {
         setvpos(1 + i,1);
         xprintf(vputs,"%s: %s",labels[i],
            (shiftstate & (0x01 << i)) ? "Yes" : "No ");
      }
   }

   /* restore screen */
   showcurs(TRUE);
   cls();
}
