/*
** RUNMENU.C: Demonstrates use of the PICTOR menu system.
*/

#include <stdio.h>
#include <pictor.h>

/* set mainloop = FALSE to terminate main loop */
int mainloop = TRUE;

VIDEOSTRUCT vstruct;
COLORSTRUCT menucolors = {
   foreback(BLACK,CYAN),
   foreback(BOLD+WHITE,CYAN),
   foreback(BOLD+CYAN,BLUE),
   foreback(BOLD+WHITE,BLUE)
};

/* give function references for menu tables */
void sample(void);
void terminate(void);

SUBMENU filemenu[] = {
   { "~New                F2",
      "Create a new file",NULL,sample },
   { "~Open...",
      "Open an existing file",NULL,sample },
   { "~Save",
      "Save the current file",NULL,sample },
   { "Save ~As",
      "Save the current file with a different name",
      NULL,sample },
   SUBMENU_DIVIDER,
   { "E~xit","Exit to DOS",NULL,terminate },
   END_SUBMENU
};

SUBMENU editmenu[] = {
   { "~Cut            Shift-Del",
      "Move text to clipboard",NULL,sample },
   { "C~opy",
      "Copy text to clipboard",NULL,sample },
   { "~Paste",
      "Paste text from clipboard",NULL,sample },
   END_SUBMENU
};

MAINMENU mainmenu[] = {
   { "~File","File operations menu",NULL,filemenu },
   { "~Edit","Edit operations menu",NULL,editmenu },
   END_MAINMENU
};

void sample(void)
{
   beep();
}

void terminate(void)
{
   mainloop = FALSE;
}

void main()
{
   int i;

   /* initialize library */
   initvideo();
   getvconfig(&vstruct);

   /* hide text cursor */
   showcurs(FALSE);

   /* Default shadow color is white on black. */
   /* Since our desktop is white on black, we need to */
   /* make shadows darker in order for them to show up */
   _PL_shadowcolor = foreback(BOLD+BLACK,BLACK);

   /* create desktop */
   for(i = 2;i < vstruct.rows;i++) {
      setvpos(i,1);
      vrepc('\xB1',vstruct.columns);
   }
   showmenu(mainmenu,&menucolors,FALSE);
   initstatus(vstruct.rows,menucolors.normal);
   statusbar("<Alt>=Menus  <F10>=Exit to DOS");

   while(mainloop) {
      switch(runmenu(mainmenu,&menucolors,&menucolors)) {
         case 0:     /* keystroke processed by runmenu */
            break;
         case F2_KEY:
            sample();
            break;
         case F10_KEY:
            mainloop = FALSE;
            break;
         default:
            beep();
            break;
      }
   }

   /* restore screen */
   vcolor(foreback(WHITE,BLACK));
   showcurs(TRUE);
   cls();
}
