/*
** wputc.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <stdio.h>
#include "pictor.h"

int _PL_wintab = 8;     /* window tab displacement */

/*
** Advances the current window pane to the next line.
*/
static void newline(void)
{
	if((_CURR_WPANE.row + 1) < getwrows())
		_CURR_WPANE.row++;
	else {
		vcolor(_CURR_WPANE.color);
		scroll(1,_CURR_WPANE.top + 1,_CURR_WPANE.left + 1,getwrows(),getwcols());
	}
	_CURR_WPANE.column = 0;

} /* scrollwin */

/*
** Writes a character to the current window.
*/
void wputc(char c)
{
	if(_PL_winhead == NULL || getwrows() < 1 || getwcols() < 1)
		return;

	switch(c) {
		case '\b':
			if(_CURR_WPANE.column > 0) {
				_CURR_WPANE.column--;
				wputc(' ');
				_CURR_WPANE.column--;
			}
			break;
		case '\n':
		case '\r':
			newline();
			break;
		case '\t':
			wrepc(' ',_PL_wintab - (_CURR_WPANE.column % _PL_wintab));
			break;
		default:
			if((unsigned)_CURR_WPANE.row < (unsigned)getwrows() &&
				(unsigned)_CURR_WPANE.column < (unsigned)getwcols()) {
				setvpos(_CURR_WPANE.top + 1 + _CURR_WPANE.row,
					_CURR_WPANE.left + 1 + _CURR_WPANE.column);
				vputca((unsigned char)c | (_CURR_WPANE.color << 8));
				_CURR_WPANE.column++;
			}
			if((_PL_winhead->style & WO_TEXTWRAP) &&
				(unsigned)_CURR_WPANE.column >= (unsigned)getwcols()) {
				newline();
			}
			break;
	}
	if(_PL_winhead->style & WO_TEXTCURSOR)
		wsynccurs();

} /* wputc */
