/*
** pushstat.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <stdio.h>
#include <stdlib.h>
#include "pictor.h"

#define STACK_SIZE   10
static int *stack[STACK_SIZE];
static int stackptr = 0;

/*
** Saves the contents of the status bar so that it can later be
** restored with popstatus. The status bar is then cleared.
** Returns TRUE if successful, FALSE if stack is full.
*/
int pushstatus(void)
{
	if(stackptr < STACK_SIZE) {
		stack[stackptr] = malloc(_PL_columns * sizeof(int));
		if(stack[stackptr] != NULL)
			getscrn(stack[stackptr],_PL_statusrow,1,1,_PL_columns);
		clrstatus();
		stackptr++;
		return(TRUE);
	}
	return(FALSE);

} /* pushstatus */

/*
** Restores the status bar to what it was the last time pushstatus
** was called. Returns TRUE if successful, FALSE if stack was empty.
*/
int popstatus(void)
{
	if(stackptr > 0) {
		stackptr--;
		if(stack[stackptr] != NULL) {
			putscrn(stack[stackptr],_PL_statusrow,1,1,_PL_columns);
			free(stack[stackptr]);
		}
		else clrstatus();
		return(TRUE);
	}
	return(FALSE);

} /* popstatus */
