/*
** getaltky.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <ctype.h>
#include "pictor.h"

static int table[] = {
	ALT_0,ALT_1,ALT_2,ALT_3,ALT_4,ALT_5,ALT_6,ALT_7,ALT_8,ALT_9,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	ALT_A,ALT_B,ALT_C,ALT_D,ALT_E,ALT_F,ALT_G,ALT_H,ALT_I,
	ALT_J,ALT_K,ALT_L,ALT_M,ALT_N,ALT_O,ALT_P,ALT_Q,ALT_R,
	ALT_S,ALT_T,ALT_U,ALT_V,ALT_W,ALT_X,ALT_Y,ALT_Z
};


/*
** Converts c to its equivelent alt-key combination code if c
** is alpha-numeric, otherwise 0 is returned.
*/
int getaltkey(int c)
{
	if(isalnum(c & 0xFF))
		return(table[toupper(c & 0xFF) - '0']);
	else
		return(0x00);

} /* getaltkey */
