/*
	PRTCODES.C - Display and modify printer codes.
*/

#include <stdio.h>
#include <process.h>
#include <ctype.h>
#include <dos.h>
#include <kbd.h>

extern int BorderClr;
extern int TitleClr;
extern int TextClr;
extern int FooterClr;
extern int HighlightClr;

void PrintCodes (void);
static void PrtTimeout (unsigned Seconds);
static int GetCode(int idx);
static int SendCode (char *ControlString);
static int ErrRtn (void);
static void DrawMenu (void);
static int IsOn(int code);
static void Highlight(int code, int idx, int row);
static void ResetAll(void);

struct PrtMnu {
	char *name;
	int status;
};

struct PrtMnu Pmnu[] = {
	" Wide       :    ", 0,
	" Condensed  :    ", 0,
	" Italics    :    ", 0,
	" Emphasized :    ", 0,
	" Bold       :    ", 0,
	" Elite      :    ", 0,
	" Subscript  :    ", 0,
	" Near LQ    :    ", 0,
	" Send Line Feed  ", 0,
	" Send Form Feed  ", 0,
	"    Reset All    ", 0
	};


static int OldRow, OldCol;

void PrintCodes ()
{
	int Row = 5;
	int Quit = 0;
	int Index = 0;

	ScrGetCur (&OldCol, &OldRow, 0);
	ScrPush();
	HideCur();
	DrawMenu();

	SetAttrib(HighlightClr, 52,Row,68,Row);
	while (!Quit)	{
		Highlight(1, Index, Row);
		switch (KbdGetC())	{
			case RET:
				if (GetCode(Index))
					Quit = 1;
				else	{
					if (IsOn(Index))
						Pmnu[Index].status = 0;
					else
						Pmnu[Index].status = 1;
				}
				break;
			case UP:
				Highlight(0, Index, Row);
				Row--;
				Index--;
				if (Row < 5)	{
					Row = 15;
					Index = 10;
				}
				break;
			case DN:
				Highlight(0, Index, Row);
				Row++;
				Index++;
				if (Row > 15)	{
					Row = 5;
					Index = 0;
				}
				break;
			case PGUP:
			case HOME:
				Highlight(0, Index, Row);
				Row = 5;
				Index = 0;
				break;
			case PGDN:
			case END:
				Highlight(0, Index, Row);
				Row = 15;
				Index = 10;
				break;
			case ESC:
				Quit = 1;
				break;
			default :
				break;
		}
	}

	PrtTimeout (20);
	ScrPop(1);
	ScrSetCur(OldCol, OldRow, 0);
	return;
}

static int GetCode(int idx)
{
	char *OnStr[] =	{
		"\x1b\x57\x31",		/* wide                  */
		"\x1b\x0f", 		/* condensed             */
		"\x1b\x34",			/* italics               */
		"\x1b\x45",			/* emphasized            */
		"\x1b\x47",			/* bold                  */
		"\x1b\x4d",			/* elite                 */
		"\x1b\x53\x01",		/* subscript             */
		"\x1b\x78\x01",		/* near letter quality   */
		"\x0a",        		/* line feed             */
		"\x0c",        		/* form feed             */
		"\x1b\x40",    		/* reset all             */
	};
	char *OffStr[] =	{
		"\x1b\x57\x30",		/* wide off                 */
		"\x12",				/* condensed off            */
		"\x1b\x35",			/* italics off              */
		"\x1b\x46",			/* emphasized off           */
		"\x1b\x48",			/* bold off                 */
		"\x1b\x50",			/* elite off                */
		"\x1b\x54",			/* subscript off            */
		"\x1b\x78\x00",		/* near letter quality off  */
		"\x0a",        		/* line feed off            */
		"\x0c",        		/* form feed off            */
		"\x1b\x40",    		/* reset all off            */
	};

	if (IsOn(idx))	{
		if (SendCode(OffStr[idx]))
			return(1);
	}
	else
		if (SendCode(OnStr[idx]))
			return(1);
	if (idx == 10)
		ResetAll();
	return(0);
}

static void ResetAll()
{
	register int i;

	for (i=0; i<8; i++)	{
		PutStr(65,5+i, FooterClr, "OFF ");
		Pmnu[i].status = 0;
	}
}

static int SendCode (char *ControlString)
{
	while (*ControlString)	{
		_DX = 0;
		_AH = 0;
		_AL = *ControlString;
		geninterrupt (0x17);
		if (_AH & 0x29)	{
			if (ErrorRtn())
				return (1);
			else
				continue;
		}
		++ControlString;
	}
	return (0);
}

static int ErrorRtn()
{
	ScrPush();
	ShadowBox(35,9,62,13, 2, BorderClr);
	PutStr(46,9, TitleClr,            " Error ");
	PutStr(36,10, TextClr,  " Error writing to printer ");
	PutStr(35,11, BorderClr, "͵");
	PutStr(36,12, FooterClr,  "      A)bort  R)etry?     ");
	PutStr(42,12, TextClr, "A");
	PutStr(50,12, TextClr, "R");
	ScrSetCur(58,12, 0);
	for (;;)
		switch (toupper(GetKey()))	{
			case 'R':
				HideCur();
				ScrPop(1);
				return(0);
			case 'A':
				HideCur();
				ScrPop(1);
				return(1);
		}
}


static void PrtTimeout (unsigned Seconds)
{
	*((char far *)0x00400078) = ++Seconds;
}

static void DrawMenu ()
{
	register int i;

	ShadowBox(51,2,69,18, 2, BorderClr);
	PutStr(51,4, BorderClr,  "͵");
	PutStr(51,16, BorderClr, "͵");
	PutStr(52,3, TitleClr,   "  Printer Setup  ");
	PutStr(52,17, FooterClr, " %c %c  %c%c%c  <Esc> ", 24, 25, 17,196,217);

	for (i=0; i<11; i++)	{
		PutStr(52,5+i, TextClr, "%s", Pmnu[i].name);
		if (i < 8)	{
			if (IsOn(i))
				PutStr(65,5+i, FooterClr, "ON  ");
			else
				PutStr(65,5+i, FooterClr, "OFF ");
		}
	}
}

static void Highlight(int code, int idx, int row)
{
	switch (code)	{
		case 0:
			PutStr(52,row, TextClr, "%s", Pmnu[idx].name);
			if (idx < 8)	{
				if (IsOn(idx))
					PutStr(65,row, FooterClr, "ON  ");
				else
					PutStr(65,row, FooterClr, "OFF ");
			}
			break;
		case 1:
			SetAttrib(HighlightClr, 52,row,68,row);
			if (idx < 8)	{
				if (IsOn(idx))
					PutStr(65,row, HighlightClr, "ON  ");
				else
					PutStr(65,row, HighlightClr, "OFF ");
			}
			break;
	}
}

static int IsOn(int code)
{
	if (Pmnu[code].status)
		return(1);
	return(0);
}