// ObjectWindows - (C) Copyright 1992 by Borland International

/*
Please see readme file for comments.
*/

#include <stdlib.h>
#include <owl.h>
#include <dos.h>
#include <alloc.h>
#include <string.h>
#include "dllhello.h"

_CLASSDEF( TDLLModule )

// class TDLLModule forces the memory for instances of the class
// to be allocated in the Dll's local heap.
// It provides an operator new to do a local alloc for instances
// of the class, and a static function to do a local alloc for the
//command line string it will save.

class TDLLModule : public TModule {
public:
	TDLLModule( LPSTR , HMODULE  , LPSTR  );
	~TDLLModule();
	void *operator new ( unsigned );
	static void * GetLocalMem( unsigned );
	static void   DeleteLocalMem( void *);
	void operator delete (void *);
};

void * TDLLModule::GetLocalMem( unsigned n )
{
	// when memory is allocated as fixed from LocalAlloc, the
	// handle returned may be used as a pointer

	return (void *)LocalAlloc( LPTR , n );
}


void *TDLLModule::operator new( unsigned n )
{
	return GetLocalMem( n );
}

void TDLLModule::DeleteLocalMem( void * p )
{
	// p is presumably a far pointer, the offset is what we
	// want to free
	LocalFree( ( HLOCAL ) FP_OFF( p ) );
}

void TDLLModule::operator delete( void * p )
{
	DeleteLocalMem( p );
}


TDLLModule::TDLLModule( LPSTR n , HMODULE hm , LPSTR cm )
		: TModule( n , hm , cm )
{
	// free the memory which the TModule constructor allocated to
	// save the command line string.  That memory is owned by the
	// EXE.
	farfree( lpCmdLine );

	// now save the command line string in local memory.
	if ( cm )
	{
		lpCmdLine = (LPSTR)GetLocalMem( strlen( cm ) + 1 );
		if ( lpCmdLine )
		{
			strcpy( lpCmdLine , cm );
		}
		else Status = EM_INVALIDMODULE;
	} else 	{
		lpCmdLine = (LPSTR)GetLocalMem( 1 );
		if ( lpCmdLine )
		{
			*lpCmdLine = 0;
		} else {
			Status = EM_INVALIDMODULE;
		}
	}
}


TDLLModule::~TDLLModule( )
{
	if ( HIWORD( lpCmdLine ) )
		DeleteLocalMem( lpCmdLine );

	// set lpCmdLine to NULL so that the ~TModule won't try to
	// free it.
	lpCmdLine = NULL;
}


PTDLLModule DLLHelloLib;

// Test function to make sure that the command line string can
// dereferenced.  Run two instances of a program linking to DLlhello,
// close the first and have the second call this function.
// Most often the command line string will be null.

extern "C" void far _export ShowCommandLine( )
{
	MessageBox( GetFocus() , DLLHelloLib->lpCmdLine , "The Dll Command Line", MB_OK );
}

BOOL far _export CreateDLLWindow(HWND ParentHWnd)
{
  PTWindowsObject AParentAlias;
  PTWindow TheWindow;

    // save the old WndProc for this window
  WNDPROC wp = (WNDPROC)GetWindowLong( ParentHWnd , GWL_WNDPROC );

  AParentAlias = DLLHelloLib->GetParentObject(ParentHWnd);
  TheWindow = new TWindow(AParentAlias, "Hello from a DLL!", DLLHelloLib);
  TheWindow->Attr.Style |= WS_POPUPWINDOW | WS_CAPTION | WS_THICKFRAME
	| WS_MINIMIZEBOX | WS_MAXIMIZEBOX;
  TheWindow->Attr.X = 100; TheWindow->Attr.Y = 100;
  TheWindow->Attr.W = 300; TheWindow->Attr.H = 300;
  PTWindow MadeWindow = (PTWindow )DLLHelloLib->MakeWindow(TheWindow) ;

    // restore the old WndProc for the main window
  SetWindowLong( ParentHWnd , GWL_WNDPROC , (DWORD) wp );

  return ( MadeWindow == TheWindow );
}

int FAR PASCAL LibMain(HINSTANCE hInstance, WORD /*wDataSeg*/,
  WORD /* cbHeapSize */, LPSTR lpCmdLine)
{
	int TheStatus;

    // Make beeps so we know when the Dll is loaded, helps debug loading
    // and unloading problems
	for ( int i = 0; i < 10 ; i ++ )
		MessageBeep( 0 );

	DLLHelloLib = new TDLLModule("DLLHello", hInstance, lpCmdLine);
	TheStatus = DLLHelloLib->Status;
	if ( TheStatus != 0 )
	{
	  delete DLLHelloLib;
	  DLLHelloLib = NULL;
	}
	return (TheStatus == 0);
}

extern "C" int FAR PASCAL WEP ( int /*bSystemExit*/ )
{
	// Make beeps so we know when we've been unloaded, helps to debug
	// WEP code not being called problems, and loading and unloading
	// problems
	for ( int i = 0; i < 10 ; i ++ )
		MessageBeep( 0 );

	delete DLLHelloLib;
	return 1;
}
