/****************************************************************************
 * Copyright (c) 1993, BSDI.  All rights reserved.
 * Program Name...  Object Engine
 * File Name......  main.cpp
 * Comments.......  Test/demo code for the object engine.
 ***************************************************************************/
#include <iostream.h>
#include <stdlib.h>
#include "test.hpp"

main()
{
    Client client;  //This declaration opens and may even create table!
    Client client2;
    struct tm testday;
    OEList objList;
    int mode = SEARCHFIRST;
                  
    cout << "Object Engine Test Program." << endl << endl;

    // Don't store all of this stuff if it has already been stored once!
    client.Setid(1000);
    if (client.LinkToKey(1, SEARCHFIRST) != PXSUCCESS)
    {
        client.Setfname("Adam");
        client.Setlname("Brittingham");
        // Inserting into an OEList automatically stores object!
        objList.Insert((PersistClass *)&client);
    
        client.Unlink();
        client.Setid(1001);
        client.Setfname("Greg");
        client.Setlname("Brittingham");
        objList.Insert((PersistClass *)&client);
    
        // Use of operator =
        client2 = client;
        // Remember to unlink if you don't want to alter original db record!
        client2.Unlink();  
        client2.Setid(1002);
        client2.Setlname("Johnson");
        objList.Insert((PersistClass *)&client2);

        // Sample showing how OELists take heterogeneous types AND how
        // to insert an object in another object's OEList.
        Test test;
        test.Setid(1000);
        test.Setweight(11.4);
        test.Setheight(72.4);
        testday.tm_mday = 29;
        testday.tm_mon = 6;
        testday.tm_year = 93;
        test.Settestdate(testday);
        objList.Insert((PersistClass *)&test);
        // Make client's "tests" OEList point to this test...
        client2.Gettests()->Insert((PersistClass *)&test);
    }

    // Demonstration of the LinkToField function (a more natural search??).
    cout << "Records with first name of Greg:" << endl;
    mode = SEARCHFIRST;
    while (client.LinkToField("FNAME", (void *)"Greg", mode) == PXSUCCESS)
    {
        mode = SEARCHNEXT;
        cout << "Name: " << client.Getid() << "  " << client.Getfname() << " " << client.Getlname() << endl;
    }
    cout << endl << endl;

    // Now search on composite secondary key!  Set up key fields and loop...
    client.Setfname("Greg");
    client.Setlname("Brittingham");
    cout << "Records matching on composite secondary key: Greg Brittingham" << endl;
    mode = SEARCHFIRST;
    while (client.LinkToSKey("Namekey", mode) == PXSUCCESS)
    {
        mode = SEARCHNEXT;
        cout << "Name: " << client.Getid() << "  " << client.Getfname() << " " << client.Getlname() << endl;
    }
    cout << endl << endl;

    // Create a client that steps through db using composite secondary key.  Note I have to
    // get the keyID value from another Client instance...
    // Also illustrates using GetStatus to iterate through all records in a database.
    FIELDHANDLE keyID;
    if (client.GetFieldHandle("Namekey", keyID) == PXSUCCESS)
    {
        cout << "Step through table sorted by composite secondary key: " << endl;
        Client client3(keyID);
        if (client3.GetStatus() != PXSUCCESS) exit(0);
        client3.LinkToFirst();
        while (client3.GetStatus() == PXSUCCESS)
        {
            cout << "Name: " << client3.Getid() << "  " << client3.Getfname() << " " << client3.Getlname() << endl;
            client3.LinkToNext();   
        }
    }
    cout << endl << endl;

    // Manually create an OEList with a specific ID.  Generally, you
    // won't do this.  Instead, you will use OELists as a portion of another
    // persistant object's record.
    OEList objList2(10);
    PersistClass *temp;

    cout << "Iterate through list #10 " << endl;
    // Painless iteration...
    while ((temp = objList2++) != NULL)
    {
        if (strcmp(temp->GetTblName(), "client") == 0)
        {
            cout << "Name: " << ((Client *)temp)->Getfname() << " " << ((Client *)temp)->Getlname() << endl;
        }
        else
        {
            cout << "Weight: " << ((Test *)temp)->Getweight() << "  Height: " << ((Test *)temp)->Getheight() << endl;
        }
    }

    return 0;
}



