/****************************************************************************
 * Copyright (c) 1993, BSDI.  All rights reserved.
 * Program Name...  Object Engine
 * File Name......  main.cpp
 * Comments.......  Test/demo code for the object engine.

    **** RENAME TO MAIN.CPP & DO "MAKE" TO SEE THIS SAMPLE RUN ****

 ***************************************************************************/
#include <iostream.h>
#include "test.hpp"

// Try sizes up to 64K to see this will continue to work
#define BUFLEN 8000U
char far buffer[BUFLEN];

main()
{
    unsigned i;
    Test test;
    Test test2;
    struct tm testday;
    BlobData blobdata;

    cout << "Object Engine Blob Buffer Test Program." << endl << endl;

    test2.Setid(5000);
    if (test2.LinkToKey(1, SEARCHFIRST) != PXSUCCESS)
    {
        Blob *localBlob = test.Getblobtest();
        // Fill buffer with 'X's for Put/Get Test
        for (i = 0; i < BUFLEN; i++) buffer[i] = 'X';
        test.Setid(5000);
        test.Setweight(11.4);
        test.Setheight(72.4);
        testday.tm_mday = 29;
        testday.tm_mon = 6;
        testday.tm_year = 93;
        test.Settestdate(testday);
        // Put the buffer into the blob using the ObjEngine shortcut...
        localBlob->OEPut(buffer, BUFLEN);
        // NOTE: Must store an object for your blob to be written to public blob in table!
        test.Store();
    }

    // **********************************************************************
    // Now Prove that the blob contains the buffer contents...
    // **********************************************************************

    // Goto the record where I put the blob...
    test2.LinkToKey(1, SEARCHFIRST);

    // Give the OEGet function a blobdata struct (so you get access not only
    // to the blob but also to it's length!)  OEGet will allocate the actual
    // blob space for you on the Global Heap and fill the space.
    // Make sure you DELETE the BlobData.data when finished with it!!!
    test2.Getblobtest()->OEGet(blobdata);

    // Remember, this is not a "string" character array.  That's why I iterate 
    // one element at a time (no 0 terminator would crash "cout << blobdata.data").
    // I use char * rather than void * to hold data just to make it a little 
    // easier to work with.
    for (i = 0; i < blobdata.size; i++)
        cout << blobdata.data[i];
    cout << endl << "I is: " << i << endl;

    // Remember to delete the space OEGet allocated for you!
    delete blobdata.data;
    return 0;
}
