// *************************************************************** //
// Filename:    DibView.h                                          //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //

#ifndef DibView_H
#define DibView_H

#include <owl\applicat.h>
#include <owl\framewin.h>
#include <owl\gdiobjec.h>
#include <owl\opensave.h>
#include <owl\printer.h>
#include <owl\dc.h>
#pragma hdrstop
#include "DibView.rh"

// --------------------------------------------------------------- //
// DibViewApplication                                              //
// --------------------------------------------------------------- //
class TDibViewApp : public TApplication 
{
  public:
    TDibViewApp();
   ~TDibViewApp();
    void InitMainWindow();
};

// --------------------------------------------------------------- //
// DibViewWindow                                                   //
// --------------------------------------------------------------- //
class TDibViewWindow : public TWindow 
{
  protected:
    TOpenSaveDialog::TData *Data;
    BOOL IsFileSelected;
    TPrinter *Printer;

    void CmFileOpen();
    void CmFileExit();
    void CmFilePrint();
    void EvEnableCmFilePrint(TCommandEnabler &);
    void EvPaint();
    void EvPaletteChanged(HWND hWndPalChg);
    BOOL EvQueryNewPalette();
    int ChangePalette();
  public:
    TDibViewWindow();
   ~TDibViewWindow();
  
    void GetWindowClass(WNDCLASS& wndClass);
    char *GetClassName();
    void SetupWindow();
    void CleanupWindow();
    
    DECLARE_RESPONSE_TABLE(TDibViewWindow);
};

// --------------------------------------------------------------- //
// TMyPrintout                                                     //
// --------------------------------------------------------------- //
class TMyPrintout : public TPrintout
{
  protected:
    char *DibFName;
  public:
    TMyPrintout(const char *title, const char *dibFName);
   ~TMyPrintout();
    void GetDialogInfo(int &minPage, int &maxPage, 
      int &selFromPage, int &selToPage);
    void PrintPage(int page, TRect &rect, unsigned flags);
    BOOL HasPage(int pageNumber)
      { return pageNumber == 1; }
};

void DibBitBlt(TDC &dc, const char *dibFName);

#endif


