/********************************************/
/*                                          */
/*    Name:NBCLIENT.C                       */
/*                                          */
/*    Purpose: Transmits a File to or       */
/*    	       from a Netbios Partner	    */
/*                                          */
/*    Revision: 01.00.00                    */
/*        Date: 06/10/91                    */
/*                                          */
/********************************************/

/* Include Statements */
#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <dir.h>
#include <string.h>
#include "nb_api.c"

/* Global Variables */
unsigned int length;
int ret,mode;
unsigned char loc_name_num,target_lsn,session_lsn;
char *buffer,*loc_name,*rem_name,temp[20],temp1[20];

/* Global Structures */
#define MAX_BUFF	63000
struct NCB ncb;
struct MSG message;

/* Function Definitions */
void create_window(int left, int top, int right, int bottom, int color);
void start_session(void);
void menu();
void dos_cmd(void);
void tx_file(void);
void rx_file(void);
void clean_up(void);

void main(void)
{

	clrscr();
	/* Allocate Memory for Buffer */
	buffer=(char *)farcalloc(MAX_BUFF+10,sizeof(char));
	if(buffer==NULL){
		printf("ERROR: Unable to allocate main buffer!\r\n");
		exit(-1);
		};
	loc_name=(char *)farcalloc(16,sizeof(char));
	rem_name=(char *)farcalloc(16,sizeof(char));
	if(rem_name==NULL){
		printf("ERROR: Unable to allocate name buffers!\r\n");
		exit(-1);
		};

	textcolor(WHITE);
	/* create_window(20,6,60,16,BLUE); */
	cprintf("\r\n\r\n         Netbios CLIENT Utility\r\n");
	cprintf("     Dawn Development Corp.   1991\r\n");
	start_session();
	menu();

	/******** Clean Up ***********/
	farfree(buffer);
	farfree(loc_name);
	farfree(rem_name);
	clean_up();

}

void create_window(int left, int top, int right, int bottom, int color)
{
	textbackground(color);
	window(left,top,right,bottom);
	clrscr();
	/* Make Border */

	window(left+1,top+1,right-1,bottom-1);
}

void start_session(void)
{
	/***************** START SESSION ************************/
	cprintf("\r\nEnter CLIENT Name: ");
	temp[0]=15;
	loc_name=cgets(temp);
	cprintf("\r\nAdding LOCAL Name to Table\r\n");
	ret=check_nb_install();
	if(ret==0){
		cprintf("\r\nERROR: Netbios NOT Installed..\r\n");
		exit(-2);
		};
	/*********** Add Local Name and Call Remote *************/
	ncb=add_name(loc_name);
	if(ncb.NCB_RETCODE!=0){
		cprintf("ERROR: Unable to ADD Local Name!\r\n");
		cprintf("ERROR: %Xh\r\n",ncb.NCB_RETCODE);
		exit(-1);
		};
	loc_name_num=ncb.NCB_NUM;
	cprintf("\r\nEnter HOST Name: ");
	temp1[0]=15;
	rem_name=cgets(temp1);
	cprintf("\r\nCalling HOST: %s\r\n",rem_name);
	ncb=call(rem_name,loc_name,0);
	if(ncb.NCB_RETCODE!=0){
		cprintf("\r\nERROR: Unable to CALL host!\r\n");
		cprintf("ERROR: %Xh\r\n",ncb.NCB_RETCODE);
		clean_up();
		};
	session_lsn=ncb.NCB_LSN;
	cprintf("Session Established....%02Xh\r\n",session_lsn);
}

void menu(void)
{

	int x;

agn:    clrscr();
	printf("(D)OS Command/(F)ile Transfer/(Q)uit: ");
	x=getch();
	x=toupper(x);
	switch(x){
		case 'D':
			dos_cmd();
		break;
		case 'F':
		agn2:	printf("(S)end/(R)eceive: ");
			x=getch();
			x=toupper(x);
			switch(x){
				case 'S':
					tx_file();
				break;
				case 'R':
					rx_file();
				break;
				default:
					goto agn2;
				break;
				};
		break;
		case 'Q':
		memset(&message,'\0',sizeof(struct MSG));
		strcpy(message.cmd,"QUIT");
		ncb=send((char *)&message,sizeof(struct MSG),session_lsn);
		if(ncb.NCB_RETCODE!=0){
			cprintf("ERROR: Send Failed!\r\n");
			cprintf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
			clean_up();
			};
			return;
                break;
		default:
			goto agn;
                break;
		};

	goto agn;
}

void dos_cmd(void)
{
	memset(&message,'\0',sizeof(struct MSG));
	strcpy(message.cmd,"DOSCMD");
	printf("\r\nEnter DOS Command:\r\n");
	gets(message.text);
	printf("COMMAND: %s\r\n",message.cmd);
	printf("TEXT: %s\r\n",message.text);
	ncb=send((char *)&message,sizeof(struct MSG),session_lsn);
	if(ncb.NCB_RETCODE!=0){
		cprintf("ERROR: Send Failed!\r\n");
		cprintf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
		clean_up();
		};
	printf("Waiting for Status Code...");
	ncb=receive((char *)&message,sizeof(struct MSG),session_lsn);
	if(ncb.NCB_RETCODE!=0){
		cprintf("ERROR: Receive Failed!\r\n");
		cprintf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
		clean_up();
		};
	ret=strcmp(message.cmd,"STATUS");
	if(ret==0){
		printf("%s\r\n",message.text);
		}
	else{
		printf("\r\nUnkown Message Received\r\n");
		};

}

void tx_file(void)
{


}

void rx_file(void)
{
	/** Client will receive file ****/

	FILE *fl;
	int ret;
	char text[80];
	unsigned count;
	unsigned long len;

	/** Send request to Host **/
	memset(&message,'\0',sizeof(struct MSG));
	strcpy(message.cmd,"RXFILE");
	printf("\r\nEnter file to receive from Host: ");
	gets(message.text);
	printf("\r\nEnter file to save as on Client: ");
	gets(text);
	ncb=send((char *)&message,sizeof(struct MSG),session_lsn);
	if(ncb.NCB_RETCODE!=0){
		cprintf("ERROR: Send Failed!\r\n");
		cprintf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
		clean_up();
		};
	/** Open file **/
	fl=fopen(text,"w+b");
	if(fl==NULL){
		printf("Unable to CREATE file...\r\n");
		clean_up();
		};
	/* Start Receiving File from Host */
	count=0;
	while(ncb.NCB_LENGTH<MAX_BUFF){
		ncb=receive((char *)&buffer,MAX_BUFF,session_lsn);
		if(ncb.NCB_RETCODE!=0){
			cprintf("ERROR: Receive Failed!\r\n");
			cprintf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
			clean_up();
			};
		ret=fwrite(buffer,1,ncb.NCB_LENGTH,fl);
		count+=ret;
		printf("\rReceived %7u bytes...",count);
		};

	fclose(fl);



}

void clean_up(void)
{
	printf("\r\nTerminating Session...\r\n");
	ncb=hang_up(session_lsn);
	if(ncb.NCB_RETCODE!=0){
		cprintf("ERROR: Hang Up Failed!\r\n");
		cprintf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
		exit(-1);
		};
	printf("Removing Local Name from Table...\r\n");
	ncb=del_name(loc_name);
	if(ncb.NCB_RETCODE!=0){
		cprintf("ERROR: Delete Name Failed!\r\n");
		cprintf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
		exit(-1);
		};
	fcloseall();
	exit(0);
}