/*

	Hardware Defines for Roland MPU-401 Midi Processing Unit

*/
#ifndef MPUREGS_H
#define MPUREGS_H



#define MPU_NOT_READY_TO_SEND    0x40 // DRR
#define MPU_NOT_READY_TO_RECEIVE 0x80 // DSR

// Messages

#define IsMpuMessageNumber(data) ((data) >= 0xF0)

#define TRACK_DATA_REQUEST_MSG 0xF0
#define TIMING_OVERFLOW_MSG 0xF8
#define CONDUCTOR_DATA_REQUEST_MSG 0xF9
#define ALL_END_MSG 0xFC
#define CLOCK_TO_HOST_MSG 0xFd
#define ACK_MSG 0xFE
#define SYSTEM_MESSAGE_MSG 0xFF

// Start/Stop Commands

#define MIDI_STOP 0x01
#define MIDI_START 0x02
#define MIDI_CONTINUE 0x03

#define PLAY_STOP 0x04
#define PLAY_START 0x08
#define PLAY_CONTINUE 0x0C

#define RECORD_STOP 0x10
#define RECORD_START 0x20


// Commands
#define DISABLE_ALL_NOTES_OFF_CMD 0x30
#define DISABLE_REAL_TIME_OUT_CMD 0x32
#define TIMING_BYTE_ALWAYS_CMD 0x34
#define MODE_MESS_ON_CMD 0x35
#define EXCLUSIVE_THRU_ON_CMD 0x37
#define COMMON_TO_HOST_ON_CMD 0x38
#define REAL_TIME_TO_HOST_ON_CMD 0x39
#define UART_MODE_CMD 0x3F		// don't use this!


#define INT_CLOCK_CMD 0x80
#define FSK_CLOCK_CMD 0x81
#define MIDI_CLOCK_CMD 0x82
#define METRONOME_ON_CMD 0x83
#define METRONOME_OFF_CMD 0x84
#define METRONOME_W_ACCENTS_CMD 0x85
#define BENDER_OFF_CMD 0x86
#define BENDER_ON_CMD 0x87
#define MIDI_THRU_OFF_CMD 0x88
#define MIDI_THRU_ON_CMD 0x89
#define DATA_IN_STOP_MODE_OFF_CMD 0x8A
#define DATA_IN_STOP_MODE_ON_CMD 0x8B
#define SEND_MEASURE_END_OFF_CMD 0x8C
#define SEND_MEASURE_END_ON_CMD 0x8D
#define CONDUCTOR_OFF_CMD 0x8E
#define CONDUCTOR_ON_CMD 0x8F
#define REAL_TIME_AFFECTION_OFF_CMD 0x90
#define REAL_TIME_AFFECTION_ON_CMD 0x91
#define FSK_TO_INTERNAL_CMD 0x92
#define FSK_TO_MIDI_CMD 0x93
#define CLOCK_TO_HOST_OFF_CMD 0x94
#define CLOCK_TO_HOST_ON_CMD 0x95
#define EXCLUSIVE_TO_HOST_OFF_CMD 0x96
#define EXCLUSIVE_TO_HOST_ON_CMD 0x97

#define RESET_RELATIVE_TEMPO_CMD 0xB1
#define CLEAR_PLAY_COUNTERS_CMD 0xB8
#define CLEAR_PLAY_MAP_CMD 0xB9
#define CLEAR_RECORD_COUNTER_CMD 0xBA
#define TIMEBASE_48_CMD 0xC2
#define TIMEBASE_72_CMD 0xC3
#define TIMEBASE_96_CMD 0xC4
#define TIMEBASE_120_CMD 0xC5
#define TIMEBASE_144_CMD 0xC6
#define TIMEBASE_168_CMD 0xC7
#define TIMEBASE_192_CMD 0xC8

#define REQUEST_TO_SEND_DATA_CMD 0xD0 /* + track #! */
#define REQUEST_TO_SEND_SYSTEM_MSG_CMD 0xDF

#define SET_TEMPO_CMD 0xE0
#define RELATIVE_TEMPO_CMD 0xE1
#define RELATIVE_TEMPO_GRADUATION_CMD 0xE2
#define MIDI_METRONOME_CMD 0xE4
#define MEASURE_LENGTH 0xE6
#define INTERNAL_CLOCK_LENGTH_TO_HOST_CMD
#define ACTIVE_TRACK_MASK_CMD 0xEC
#define SEND_PLAY_COUNTER_MASK_CMD 0xED
#define MIDI_CHANNEL_MASK_LO_CMD 0xEE
#define MIDI_CHANNEL_MASK_HI_CMD 0xEF
#define EOX_CMD 0xF7
#define RESET_CMD 0xFF


// Commands that send data
#define REQUEST_PLAY_COUNTER_CMD 0xA0
#define REQUEST_AND_CLEAR_PLAY_COUNTER_CMD 0xAB
#define REQUEST_VERSION_CMD 0xAC
#define REQUEST_REVISION_CMD 0xAD
#define REQUEST_TEMPO_CMD 0xAF





#define TIMING_OVERFLOW_CMD 0xF8
#define MPU_MARK_CMD 0xFC
#define MPU_RESET_CMD 0xFF





#endif // !defined MPUREGS_H
