// *************************************************************** //
// Filename:    MPD.h                                              //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //

#ifndef MPD_H
#define MPD_H

#include <owl\owlcore.h>
#include <owl\listbox.h>
#include <owl\layoutwi.h>
#include <owl\button.h>
#pragma hdrstop
#include "MPD.rh"

// --------------------------------------------------------------- //
// MPDApplication                                                  //
// --------------------------------------------------------------- //
class TMPDApp : public TApplication 
{
  public:
    TMPDApp();
   ~TMPDApp();
    void InitMainWindow();
};

struct ItemData
{
  TResId Icon;
  TResId Dialog;
};

class TMyListBox : public TListBox
{
  public:
    TMyListBox(TWindow *parent, int resId, TModule *module = 0);
    TMyListBox(TWindow *parent, int id,
      int x, int y, int w, int h,
      TModule *module = 0);
    
    void AddItem(const char *text, TResId icon, TResId dialog);
    void CleanupWindow();
    void ODADrawEntire(DRAWITEMSTRUCT &drawInfo);
    void ODAFocus(DRAWITEMSTRUCT &drawInfo);
    void ODASelect(DRAWITEMSTRUCT &drawInfo);
  protected:
    void DrawEntry(DRAWITEMSTRUCT &drawInfo);
};

// --------------------------------------------------------------- //
// MPDWindow                                                       //
// --------------------------------------------------------------- //
class TMPDWindow : public TLayoutWindow
{
  public:
    TMPDWindow();
   ~TMPDWindow();
    void SetupWindow();
    void CleanupWindow();

    DECLARE_RESPONSE_TABLE(TMPDWindow);
  protected:
    TMyListBox *lb;
    TDialog *dlg;
    void EvMeasureItem(UINT ctrlId, MEASUREITEMSTRUCT &measureInfo);
    void EvLbnSelChange();
};

#endif

