/*
 * Module : gsx.c
 * Purpose: PC Simulation of GSX - SIMPLE Graphics Support for X.
 * Written by ranco on March 92.
 */


#define MOUSE_MASK CURSOR_LOCATION_CHANGED | LEFT_BUTTON_PRESSED |    \
		   LEFT_BUTTON_RELEASED | RIGHT_BUTTON_PRESSED |       \
		   RIGHT_BUTTON_RELEASED | MIDDLE_BUTTON_PRESSED |      \
		   MIDDLE_BUTTON_RELEASED


/*
 *	Drawing modes.
 */
#define	NORMAL		0
#define	INVERTED	1


/*
 *	Event strucure.
 */
typedef struct {
	int x;
	int y;
	int width;
	int height;
	unsigned int key;
	unsigned int state;
	char string[100];
} GEvent ;
 
#define GEventX(e)      ((e)->x)
#define GEventY(e)      ((e)->y)
#define GEventW(e)      ((e)->width)
#define GEventH(e)      ((e)->height)
#define GEventKey(e)    ((e)->key)
#define GEventState(e)  ((e)->state)
 
/*
 *	Event handling function type definition.
 */

typedef void (*FuncV)(GEvent);
typedef void (*GFunction)(GEvent);

#define GNULLFUNCTION (GFunction) GNullEvent

/*
 *	Possible events structure definition.
 */
typedef enum {
	GNull, GExpose,
	GButton1Press, GButton2Press, GButton3Press,
	GButton1Release, GButton2Release, GButton3Release,
	GDrag, GMotion, GKey, GString
} GEventT;


extern MaxX, MaxY;

void GNullEvent (GEvent g_event);

/* General functions prototyping. */
void GMainLoop(void);
void GFuncSet(FuncV, GEventT);
void GWindow(int x, int y, int w, int h, char *name);
void GcloseWindow (void);

/* Drawing functions prototyping. */
void GCircle(int x, int y, int r);
void GCircleFill(int x, int y, int r);
void GLine(int x1, int y1, int x2, int y2);
void GText(int x, int y, char *text_string);
void GRectangle(int x, int y, int w, int h);
void GRectangleFill(int x, int y, int w, int h);
 
/* Control functions prototyping. */
void GClear(void);
void GDrawMode(int mode);
void GSetForeground(int c);
void GLinewidth(unsigned int w);
