	// sbdrdem2.cpp
	// Demo Streamable Binder with streamable nodes
	// Link with binder.obj and sbinder.obj
	
	#include <string.h>
	#include <fstream.h>
	#include <iomanip.h>
	#include "sbinder.hpp"

	#define ID_StreamableString		3

	class StreamableString : Streamable  {
		char * s;
		int slen;
	protected:
		void construct(char *s, int slenNotClone);
	public:
		STREAMABLE(StreamableString,
			ID_StreamableString,
			Streamable);
		StreamableString(char *s,
			int slenNotClone = 0)
			: Streamable(UNIQUE_STREAMABLE,
				ID_CLASS)
			{ construct(s,slenNotClone); }
		ostream& printOn(ostream& os);
		operator char *() { return s; }
		virtual ~StreamableString()
			{ delete s; }
	};
	typedef StreamableString * StreamableStrinG;


	ostream& StreamableString::store(ostream& os)
	{
		if (!(os << slen << endm))
			serror("unable to store"
				"string length, id: ");
		else if (slen)  {
			os.write(s,slen);
			if (!os)
				serror("unable to store"
				"string, id: ");
		}
		return os;
	}

	StreamablE StreamableString::load(istream& is,
		StreamablE InstancE)
	{

		int slen;
		char * s;

		if (!(is >> slen >> nextm))  {
			lserror("loading slen",
				ID_CLASS);
			return StreamablE0;
		}
		else if ((s = new char[slen+1])
			!= (char *)0)  {
			if (slen)  {
				is.read(s,slen);
				if (!is)  {
					lserror("loading "
						"string",
						ID_CLASS);
					delete s;
					return StreamablE0;
				}
			}
			s[slen] = '\0';			
		}
		else  {
			lserror("unable to allocate memory "
				"for string",ID_CLASS);
			return StreamablE0;
		}
		if (!InstancE) if ((InstancE = (StreamablE)
			new StreamableString
			(UNIQUE_STREAMABLE)) == StreamablE0)  {
			lserror("unable to construct"
				" StreamableString",
				ID_CLASS);
			delete s;
			return InstancE;
		}
		((StreamableStrinG)InstancE)
			->construct(s,slen);
		return InstancE;
	}
	
	void StreamableString::construct(char *s,
		int slenNotClone)
	{
		if (slenNotClone)  {
			this->s = s;
			slen = slenNotClone;
		}
		else if (s)
			if ((this->s = strdup(s))
				!= (char *)0)
				slen = strlen(s);
			else
				slen = 0;
		else  {
			this->s = (char *) 0;
			slen = 0;
		}
	}

	ostream& StreamableString::printOn(ostream& os)
	{
		if (s) if (strlen(s))
			return os << s << endl;
		else
			return os << "empty string" << endl;
		return os << "NULL string" << endl;
	}

	void display(StreamableStrinG S)
	{
		cout << "Address: " << S
			<< "   String:   ";
		S->printOn(cout);
	}



	main()
	{
		SBinder::registerClass();
		StreamableString::registerClass();

		SBinder B;

		B.push(new
			StreamableString("Now is the time"));
		B.insQ(new
			StreamableString("for all programmers"));
		B.atIns(B.Nodes(),new
			StreamableString("to stop reinventing"));
		B.insQ(new
			StreamableString("the linked list!"));
		B.insQ(B.bottom());
		B.insQ(new
			StreamableString("Line above for "
				"testing multiple linking!"));

		B.forEach((BDRforEachBlocK)display);
		
		B.link();  // required for streaming!

		cout << "\n\npress enter to continue ...";
		cin.get();


		ofstream oS("sbdrdem2.txt");
		if (oS)  {

			oS << (StreamablE) B;
			B.restream();
			oS.close();
			ifstream iS("sbdrdem2.txt");
			if (iS)  {
				StreamablE C;
				iS >> C;
				iS.close();
				RestreamRegistry();
				if (C)
				{
				  cout << "\n\nStreamed and "
					<< "reloaded Binder "
					<< "with streamable nodes \n\n";
				  ((SBindeR)C)->forEach(
				  	(BDRforEachBlocK)display);
				  delete (SBindeR) C;
				}
				else
				  cout << "\n\nUnable to reload"
				    << " Binder \n\n";
			}
			else
				cout << "\n\nUnable to reopen"
				  << " stream for input of"
				  << " of Binder \n\n";
		}
		
		B.unlink();

		return 0;
	}