/*

	cbinder.cpp
	10-25-91
	Copy Binder: Loose Data Binder v 1.5

	Copyright 1991
	John W. Small
	All rights reserved

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#include "cbinder.hpp"


/*  Copy Binder Primitives  */

void CBinder::Dstore(ostream& os, voiD D)
{
	if (!D)
		return;
	if (sizeofData)  {
		os.write((const char *)D,sizeofData);
		if (!os)
			serror("unable to store CBinder "
				"node (fixed sized data)");
	}
	else  {
		unsigned i;
		os << (i = (unsigned) strlen((char *)D))
			<< endm;
		if (i)
			os.write((char *)D,i);
		if (!os)
			serror("unable to store CBinder "
				"node (string data)");
	}
}

voiD CBinder::Dload(istream& is)
{
	char * D;

	if (sizeofData) {
		if ((D = new char[sizeofData])
			!= (char *)0)  {
			is.read(D,sizeofData);
			if (!is)  {
				serror("loading CBinder "
					"node (fixed sized "
					"data)");
				delete D;
				D = (char *) 0;
			}
		}
		else
			serror("unable to allocate memory "
				"for CBinder node "
				"(fixed size data)");
	}
	else  {
		unsigned i;

		D = (char *) 0;
		if (!(is >> i >> nextm))
			serror("loading CBinder node "
				"(string data)");
		else if ((D = new char[i+1])
			!= (char *)0)  {
			if (i)  {
				is.read(D,i);
				if (!is)  {
					serror("loading "
						"CBinder "
						"node "
						"(string "
						"data)");
					delete D;
					D = (char *) 0;
				}
				else
					D[i] = '\0';
			}
			else
				D[i] = '\0';
		}
		else
			serror("unable to allocate memory "
				"for CBinder node "
				"(string data)");
	}

	return (voiD) D;
}

voiD CBinder::Dclone(const voiD D)
{
	voiD cD;

	if (!D)
		return voiD0;
	if (sizeofData)  {
		if ((cD = (voiD) new char[sizeofData])
			!= voiD0) memcpy(cD,D,sizeofData);
	}
	else if ((cD = (voiD) new char[strlen((char *)D)+1])
		!= voiD0) strcpy((char *)cD,(char *)D);
	return cD;

}

voiD CBinder::Dcopy(voiD D, const voiD S)
{
	if (D && S && D != S)  {
		if (sizeofData)
			memcpy(D,S,sizeofData);
		else
			strcpy((char *)D,(char *)S);
		return D;
	}
	return voiD0;
}

ostream& CBinder::store(ostream& os)
{	/* Store CBinder sizeofData field then Binder! */
	if (!(os << sizeofData << endm))
		serror("unable to store CBinder");
	else
		SBinder::store(os);
	return os;
}

StreamablE CBinder::load(istream& is, StreamablE InstancE)
{
	unsigned sizeofData;
	int newed = 0;

	if (!(is >> sizeofData >> nextm))  {
		lserror("unable to load CBinder "
			"header data",ID_CLASS);
		return StreamablE0;
	}
	if (!InstancE)  {
		if ((InstancE = (StreamablE)
			new CBinder(UNIQUE_STREAMABLE))
			== StreamablE0)  {
			lserror("unable to construct "
				"CBinder",ID_CLASS);
			return StreamablE0;				
		}
		newed = 1;
	}
	((CBindeR)InstancE)->construct(sizeofData);
	StreamablE ancestoR =  SBinder::load(is,InstancE);
	if (!ancestoR)  {
		// ((CBindeR)InstancE)->destruct();
		if (newed)
			delete InstancE;
		return StreamablE0;
	}
	return ancestoR;
}

CBinder::CBinder(unsigned sizeofData,
	unsigned maxNodes, unsigned limit,
	unsigned delta)
	: SBinder(BDR_OK_FREE,maxNodes,
		limit,delta)
{
	construct(sizeofData);
	setID(ID_CLASS);
}

voiD CBinder::atInsCLN(unsigned n, const voiD D)
{
	voiD cD;

	if (!atIns(n,cD = Dclone(D)))  {
		Dfree(cD);
		return voiD0;
	}
	return cD;
}

voiD CBinder::atFreeCPY(unsigned n, voiD D)
{
	return (Dcopy(D,atGet(n))? atFree(n), D : voiD0);
}

voiD CBinder::atPutCLN(unsigned n, const voiD D)
{
	voiD oldD, cD;

	if ((oldD = atGet(n)) == voiD0)
		return voiD0;
	if (oldD == D)
		return voiD0;
	if (!atPut(n,cD = Dclone(D)))  {
		Dfree(cD);
		return voiD0;
	}
	Dfree(oldD);
	return cD;
}

CBinder::operator char *()
{
	return (char *) (sizeofData? 0 : current());
}

voiD CBinder::pushCLN(const voiD D)
{
	voiD cD;

	if (!push(cD = Dclone(D)))  {
		Dfree(cD);
		return voiD0;
	}
	return cD;
}

voiD CBinder::popFreeCPY(voiD D)
{
	return (Dcopy(D,atGet(0))? atFree(0), D : voiD0);
}

voiD CBinder::insQCLN(const voiD D)
{
	voiD cD;

	if (!insQ(cD = Dclone(D)))  {
		Dfree(cD);
		return voiD0;
	}
	return cD;
}

voiD CBinder::rmQFreeCPY(voiD D)
{
	return (Dcopy(D,atGet(0))? atFree(0), D : voiD0);
}

voiD CBinder::unQFreeCPY(voiD D)
{
	return (Dcopy(D,bottom())? unQFree(), D : voiD0);
}

voiD CBinder::insCLN(const voiD D)
{
	voiD cD;

	if (!ins(cD = Dclone(D)))  {
		Dfree(cD);
		return voiD0;
	}
	return cD;
}

voiD CBinder::insSortCLN(const voiD D)
{
	voiD cD;

	if (!insSort(cD = Dclone(D)))  {
		Dfree(cD);
		return voiD0;
	}
	return cD;
}

voiD CBinder::delFreeCPY(voiD D)
{
	return (Dcopy(D,current())? delFree(), D : voiD0);
}

voiD CBinder::nextCPY(voiD D)
	{ return (D? Dcopy(D,next()) : voiD0); }

voiD CBinder::prevCPY(voiD D)
	{ return (D? Dcopy(D,prev()) : voiD0); }

