//===============================================================
//   Project...:    kscxms.lib
//   File Name.:    xmstest.cpp
//   Date......:    October 17, 1994
//   Version...:    1.0
//   COPYRIGHT (c) 1994 by Kenneth S. Cascio.
//   All Rights Reserved!
//===============================================================

// THIS PROGRAM REQUIRES 2000KB OF XMS

#include <conio.h>
#include <stdlib.h>
#include "kscxms.h"

int main()
{
	long i, j, k, l, m;
	long temp;
	char test;

	// Clear display (conio.h)
	clrscr();

	cout << "Testing XMS_STATS..." << endl;

	// Create an XMS_STATS object, stats, to hold the return of
	//  the memory checking function XMS_Verify().
	XMS_STATS stats;
	stats = XMS_Verify();

	// Display XMS stats returned by XMS_Verify()
	cout << "stats.XMS_Present = " << stats.XMS_Present << endl;
	cout << "stats.XMS_Available = " << stats.KB_Available
		<< endl;
	cout << "stats.XMS_Largest = " << stats.KB_Largest << endl;

	// If the host system does not have atleast 2000KB of XMS
	//  available to KSCXMS.LIB, report error and terminate.
	if (stats.KB_Largest < 2000) {
		cout << "Not Enough Memory to Continue!" << endl;
		exit(99);
	}

	cout << "Initializing control_1 and control_2." << endl;

	// Create two KSCXMS.LIB controllers.  Each controller
	//  request 1000KB of XMS.
	XMSCONTROL control_1(1000);
	XMSCONTROL control_2(1000);

	cout << "Selecting control_1..." << endl;

	// Make control_1 active.  All memory allocation will use
	//  this controller until another is selected via a
	//  similar call.
	control_1.select();

	cout << "Creating m_object_1 & m_object_2 5D arrays."
		<< endl;

	// Create two five-dimensional XMS arrays holding 100,000
	//  long vaules each.  This array uses the XMSOBJM template
	//  to overload the math and display operators.  This may
	//  not seem like alot but each array uses 400,000 bytes
	//  of memory.  Try that in real-memory.
	XMSOBJM<long> m_object_1(10, 10, 10, 10, 10);
	XMSOBJM<long> m_object_2(10, 10, 10, 10, 10);

	cout << "Loading both XMS arrays...";

	// Load both arrays
	for (i = 0; i < 10; i++) {
		for (j = 0; j < 10; j++) {
			for (k = 0; k < 10; k++) {
				for (l = 0; l < 10; l++) {
					for (m = 0; m < 10; m++) {
						temp = (i * j * k * l * m);
						m_object_1(i, j, k, l, m) = temp;
						m_object_2(m, l, k, j, i) = temp;
					}
				}
			}
		}
	}

	cout << " Complete!" << endl;

	// Set to true stae using KSCXMS.LIB macro TRUE
	test = TRUE;

	cout << "Comparing XMS arrays....";

	// Verify both arrays actually contain data stored above
	for (i = 0; i < 10; i++) {
		for (j = 0; j < 10; j++) {
			for (k = 0; k < 10; k++) {
				for (l = 0; l < 10; l++) {
					for (m = 0; m < 10; m++) {
						temp = (i * j * k * l * m);
						if (m_object_1(i, j, k, l, m) != temp) {
							test = FALSE;
						}

						if (m_object_2(m, l, k, j, i) != temp) {
							test = FALSE;
						}

						// If test fails, report an error and shut-
						//  down KSCXMS.LIB prior to abnormal
						//  termination.
						if (!test) {
							cout << "Compare Error!" << endl;
							control_1.release();
							control_2.release();
							exit(99);
						}
					}
				}
			}
		}
	}

	cout << " Complete!" << endl;
	cout << "Releasing both m_objects..." << endl;

	// Release both control_1 objects.
	m_object_1.kill();
	m_object_2.kill();

	cout << "Creating two newArrays..." << endl;

	// Create new XMSOBJ array using control_1
	XMSOBJM<long> newArray_1(250000L);

	// Select control_2 for creation of new objects
	control_2.select();

	// Create new XMSOBJ array using control_2
	XMSOBJS<long> newArray_2(250000L);

	cout << "Loading newArray_1 & newArray_2...";

	// Load both newArray objects
	for (i = 0; i < 250000L; i++) {
		newArray_1(i) = i;
		*newArray_2(i) = i;
	}

	cout << " Complete!" << endl;
	cout << "Performing: newArray_1 = newArray_1 + newArray_2...";

	// Manipulate newArray_1.
	for (i = 0; i < 250000L; i++) {
		newArray_1(i) += *newArray_2(i);
	}

	cout << " Complete!" << endl;
	cout << "Performing: newArray(i) += newArray(i + 1)...";

	// Manipulating newArrays.
	for (i = 0; i < 249999L; i++) {
		newArray_1(i) += newArray_1(i + 1);
		*newArray_2(i) += *newArray_2(i + 1);
	}

	cout << " Complete!" << endl;
	cout << "Releasing both newArrays." << endl;

	// Release both newArray objects.
	newArray_1.kill();
	newArray_2.kill();

	// Create structure to store in the XMS
	struct TSTRUCT {
		int intVar;
		long longVar;
		float floatVar;
		double doubleVar;
	};

	// Select controller control_1 for new XMSOBJ's
	control_1.select();

	// Create array of TSTRUCTs
	XMSOBJS<TSTRUCT> tArray(50000L);

	cout << "Loading tArray (array of TSTRUCTs)...";

	// Load tArray.
	for (i = 0; i < 50000L; i++) {
		tArray(i)->intVar = 1;
		tArray(i)->longVar = 2;
		tArray(i)->floatVar = 3;
		tArray(i)->doubleVar = 4;
	}

	cout << " Complete!" << endl;
	cout << "Comparing tArray...";

	test = TRUE;

	// Test tArray load function above
	for (i = 0; i < 50000L; i++) {
		if (tArray(i)->intVar != 1) test = FALSE;
		if (tArray(i)->longVar != 2) test = FALSE;
		if (tArray(i)->floatVar != 3) test = FALSE;
		if (tArray(i)->doubleVar != 4) test = FALSE;
	}

	cout << " Complete!" << endl;
	cout << "Testing tArray for errors." << endl;

	// Error if test failed.
	if (!test) {
		cout << "tArray compare function failed..." << endl;
		control_1.release();
		control_2.release();
		exit(999);
	}

	cout << "Release both controllers and terminate." << endl;

	// Release both controllers to return controll of XMS to
	//  DOS.  This step is not absolutely necessary during a
	//  normal termination but I do it any way.  Better safe
	//  than sorry.
	control_1.release();
	control_2.release();

	// Normal termination
	return 0;
}

//  END - XMSTEST.CPP



