//	=========================================================================
//	Project...:	kscxms.lib
//	File Name.:	kscxms.h
// Date......:	October 17, 1994
//	Version...:	6.2
//	COPYRIGHT (c) 1994 by Kenneth S. Cascio.  All Rights Reserved
//	=========================================================================

#ifdef __BCPLUSPLUS__
	#pragma option -a2
#endif

#ifndef __LARGE__
	#error This program MUST be compiled in the LARGE memory model!
#endif

#ifndef		__KSCXMS_H
#define		__KSCXMS_H

#include <iostream.h>

#ifndef TRUE
	#define	TRUE			 1
#endif

#ifndef FALSE
	#define	FALSE			 0
#endif

#ifndef NULL
	#define	NULL			 0
#endif

#define MAXCONTROLLERS	 5
#define MAPARRAYSIZE		 5
#define FRAMESIZE			 128
#define LOADMETHOD		 Smart

enum ORIENTATION {Check, Left, Right, Center, Smart};

enum SCOPECODE {Normal, Alter};

class XMSACCESS;
class XMSCONTROL;

struct XMS_PARAMETERS {
	unsigned long byteCount;
	unsigned int sourceHandle;
	far void *sourcePtr;
	unsigned int destHandle;
	far void *destPtr;
};

struct XMSMAP {
	int map_ID;
	char inUse;
	char mapDirty;
	char frameDirty;
	XMSACCESS far *owner;
	unsigned int sizeOne;
	unsigned long firstItem;
	unsigned long lastItem;
	unsigned long XMS_Offset;
	unsigned long totalBytes;
};

struct XMS_STATS {
	char XMS_Present;
	int KB_Available;
	int KB_Largest;
};

struct CONTROLSTATS {
	char status;
	int KB_Available;
	int KB_Largest;
	int KB_Requested;
	int KB_Allocated;
	int mapSize;
	int lastMap;
	unsigned int mapArraySize;
	unsigned long XMS_Free;
	unsigned long XMS_Largest;
	unsigned long XMS_Used;
	unsigned long XMS_Top;
	unsigned long XMS_Bottom;
	int MapArraySize;
	int FrameSize;
	ORIENTATION LoadMethod;
};

XMS_STATS XMS_Verify(void);
int setMaxControllers(int newSize = -1);
int setMapArraySize(int newSize = -1);
int setFrameSize(int newSize = -1);
int setLoadMethod(ORIENTATION newMethod = Check);

class XMSSHARED {
	friend int setMaxControllers(int newSize = -1);
	friend int setMapArraySize(int newSize = -1);
	friend int setFrameSize(int newSize = -1);
	friend int setLoadMethod(ORIENTATION newMethod = Check);

private:
	static unsigned long checkSum;

protected:
	static int MaxControllers;
	static int MapArraySize;
	static int FrameSize;
	static ORIENTATION LoadMethod;

protected:
	static int numActive;
	static int maxLoc;
	static int selectedLoc;
	static XMSCONTROL far **ctrlArray;

private:
	static char far *decode(char far *text, int length);
	static void copyRight(void);

protected:
	static char install(XMSCONTROL far *controller);
	static char remove(XMSCONTROL far *controller);
	static char shutDown(void);

public:
	XMSSHARED();
	~XMSSHARED();

protected:
	static void error(int err = 0);
};

class XMSCONTROL : protected XMSSHARED {
	friend XMSACCESS;

private:
	char status;
	unsigned int XMS_Handle;
	int KB_Available;
	int KB_Largest;
	int KB_Requested;
	int KB_Allocated;
	int mapSize;
	int lastMap;
	XMSMAP far *mapArray;
	unsigned int mapArraySize;
	unsigned long XMS_Free;
	unsigned long XMS_Largest;
	unsigned long XMS_Used;
	unsigned long XMS_Top;
	unsigned long XMS_Bottom;

private:
	XMSMAP far *getMap(int mapLocation);
	char XMS_Compress(void);
	char XMS_StartUp(void);
	void XMS_ClearMaps(void);
	unsigned int XMS_CheckMap(int map_ID, char allocating = FALSE);
	void XMS_WriteMap(int map_ID, void huge *source = NULL);
	void XMS_ReadMap(int map_ID, void huge *destination = NULL);

public:
	XMSCONTROL();
	XMSCONTROL(unsigned int KB);
	~XMSCONTROL();

public:
	CONTROLSTATS getStats(void);
	char success(void);
	int sizeMapArray(int newSize = -1);
	char select(void);
	unsigned long XMS_Available(int objects = 1);
	void release(char shutDown = FALSE);
};

class XMSACCESS : protected XMSSHARED {
	friend XMSCONTROL;

public:
	char status;
	XMSCONTROL far *master;
	int map_ID;

public:
	ORIENTATION orientation;
	unsigned int frameSize;
	void huge *frame;
	unsigned long elements;

public:
	void checkFrame(int sizeT);
	char allocate(unsigned int size);
	char release(void);
	void saveFrame(void);
	unsigned int scope(unsigned long newItem, SCOPECODE code = Normal);
	char copy(int direction, void huge *memPtr, unsigned long bytes,
		unsigned long offset);

public:
	XMSACCESS();
	~XMSACCESS();

};

template <class T> class XMSOBJS : protected XMSSHARED {
private:
	unsigned int tVars;
	unsigned long far (*tSubs)[2];
	unsigned long tItem;

private:
	XMSACCESS far *access;
	T far *object;

private:
	void verify(int level);

public:
	XMSOBJS();
	XMSOBJS(XMSOBJS &pass);
	XMSOBJS(unsigned long m);
	XMSOBJS(unsigned long m, unsigned long n);
	XMSOBJS(unsigned long m, unsigned long n, unsigned long o);
	XMSOBJS(unsigned long m, unsigned long n, unsigned long o,
		unsigned long p);
	XMSOBJS(unsigned long m, unsigned long n, unsigned long o,
		unsigned long p, unsigned long q);
	~XMSOBJS();

	T far *operator[](unsigned long m);

	T far *operator()(unsigned long m);
	T far *operator()(unsigned long m, unsigned long n);
	T far *operator()(unsigned long m, unsigned long n, unsigned long o);
	T far *operator()(unsigned long m, unsigned long n, unsigned long o,
		unsigned long p);
	T far *operator()(unsigned long m, unsigned long n, unsigned long o,
		unsigned long p, unsigned long q);

public:
	char success(void);
	int loadMethod(ORIENTATION method = Check);
	int frameSize(int newSize = -1);
	char copy(int direction, void huge *memPtr, unsigned long bytes = 0,
		unsigned long offset = 0);
	void kill(void);
};

template <class T> class XMSOBJM : protected XMSSHARED {
private:
	unsigned int tVars;
	unsigned long far (*tSubs)[2];
	XMSOBJM far *tOwner;
	int tLevel;
	unsigned long tItem;

private:
	XMSACCESS far *access;
	T far *object;

private:
	void verify(int level);

public:
	XMSOBJM();
	XMSOBJM(XMSOBJM &pass);
	XMSOBJM(unsigned long m);
	XMSOBJM(unsigned long m, unsigned long n);
	XMSOBJM(unsigned long m, unsigned long n, unsigned long o);
	XMSOBJM(unsigned long m, unsigned long n, unsigned long o,
		unsigned long p);
	XMSOBJM(unsigned long m, unsigned long n, unsigned long o,
		unsigned long p, unsigned long q);
	~XMSOBJM();

	T operator*(void);

	XMSOBJM operator[](unsigned long m);

	XMSOBJM operator()(unsigned long m);
	XMSOBJM operator()(unsigned long m, unsigned long n);
	XMSOBJM operator()(unsigned long m, unsigned long n, unsigned long o);
	XMSOBJM operator()(unsigned long m, unsigned long n, unsigned long o,
		unsigned long p);
	XMSOBJM operator()(unsigned long m, unsigned long n, unsigned long o,
		unsigned long p, unsigned long q);

	T operator=(T t);
	T operator=(XMSOBJM &pass);

	char operator!(void);

	char operator==(T t);
	char operator||(T t);
	char operator&&(T t);
	char operator!=(T t);
	char operator< (T t);
	char operator> (T t);
	char operator<=(T t);
	char operator>=(T t);

	char operator==(XMSOBJM &pass);
	char operator||(XMSOBJM &pass);
	char operator&&(XMSOBJM &pass);
	char operator!=(XMSOBJM &pass);
	char operator< (XMSOBJM &pass);
	char operator> (XMSOBJM &pass);
	char operator<=(XMSOBJM &pass);
	char operator>=(XMSOBJM &pass);

	T operator+(T t);
	T operator-(T t);
	T operator*(T t);
	T operator/(T t);
	T operator%(T t);

	T operator+(XMSOBJM &pass);
	T operator-(XMSOBJM &pass);
	T operator*(XMSOBJM &pass);
	T operator/(XMSOBJM &pass);
	T operator%(XMSOBJM &pass);

	T operator+=(T t);
	T operator-=(T t);
	T operator*=(T t);
	T operator/=(T t);
	T operator%=(T t);

	T operator+=(XMSOBJM &pass);
	T operator-=(XMSOBJM &pass);
	T operator*=(XMSOBJM &pass);
	T operator/=(XMSOBJM &pass);
	T operator%=(XMSOBJM &pass);

	T operator++(void);
	T operator--(void);
	T operator++(int);
	T operator--(int);

	friend ostream &operator<<(ostream &out_data, XMSOBJM<T> &pass);
	friend istream &operator>>(istream &in_data, XMSOBJM<T> &pass);

public:
	char success(void);
	int loadMethod(ORIENTATION method = Check);
	int frameSize(int newSize = -1);
	char copy(int direction, void huge *memPtr, unsigned long bytes = 0,
		unsigned long offset = 0);
	void kill(void);
};

#ifndef	NOXMSOBJ
	#include <xmsobjs.h>
	#include <xmsobjm.h>
#endif

#endif	// __KSCXMS_H
