//===============================================================
//   Project...:    kscxms.lib
//   File Name.:    animate.cpp
//   Date......:    October 16, 1994
//   Version...:    1.0
//   COPYRIGHT (c) 1994 by Kenneth S. Cascio.
//   All Rights Reserved!
//===============================================================

// THIS PROGRAM REQUIRES 102KB OF XMS

#include <iostream.h>
#include <conio.h>
#include <stdlib.h>
#include "kscxms.h"

int main()
{
	long i, j;
	char far *video = NULL;

	// Create a XMS_STATS object to hold the return of the
	//  memory test funcing XMS_Verify().
	XMS_STATS stats;
	stats = XMS_Verify();

	// Use the value returned in stats.KB_Largest to
	//  determine if the program has enough memory
	//  to operate correctly.
	if (stats.KB_Largest < 102) {
		cout << "Not Enough Memory to Continue!" << endl;
		exit(99);
	}

	// Create a KSCXMS.LIB controller.  Since no amount of
	//  memory is expressly requested, all available XMS
	//  memory is attatched.
	XMSCONTROL controller;

	// Create a two-dimensional array in the XMS area using
	//  the overloaded template XMSOBJM.  Each block on the
	//  screen uses two bytes, 1 for the character displayed,
	//  and 1 for the attribute of that character.
	XMSOBJM<char> buffer(52000L, 2);

	// If creation of buffer failed, terminate.
	if (!buffer.success()) {
		controller.release();
		exit(99);
	}

	// Clear the screen (conio.h).
	clrscr();

	// Display message (iostream.h).
	cout << "Loading Animation Array...";

	// If using a Black & White Monitor, use 0xb000000L
	video = (char far *)0xb8000000L;

	// Load the XMS array buffer with incrimental characters
	//  of the alphabet.  The attribute byte is set to 7 which
	//  means print a white character on a black background.
	for (i = 0; i < 26; i++) {
		for (j = 0; j < 2000; j++) {
			buffer((i * 2000L) + j, 0) = (char)(65 + i);
			buffer((i * 2000L) + j, 1) = (char)7;
		}
	}

	// Display message (iostream.h).
	cout << " Complete!" << endl;
	cout << "Hit Any Key To Anaimate (with frame)...." << endl;
	cout << "frameSize = " << buffer.frameSize() << endl;

	// Pause for user to press a key (conio.h).
	while (getch() == 0) { };
	clrscr();

	// Loop 1 : copy each page (4000 bytes) from the XMS
	//  array to the video RAM and pause for a key press.
	for (i = 0; i < 26; i++) {
		buffer.copy(0, video, 4000, (i * 4000L));
		while (getch() == 0) { };
	}

	// Clear the screen (conio.h)
	clrscr();

	// Display messages (iostream.h).
	cout << "Hit Any Key To Anaimate (with out frame)...."
		<< endl;
	cout << "frameSize = " << buffer.frameSize(0) << endl;

	// Pause for key press and clear screen (conio.h).
	while (getch() == 0) { };
	clrscr();

	// Loop 2 : copy each page (4000 bytes) from the XMS
	//  array to the video RAM with out pausing.
	for (i = 0; i < 26; i++) {
		buffer.copy(0, video, 4000, (i * 4000L));
	}

	// Clear screen (conio.h).
	clrscr();

	// Execute normal termination.
	return 0;
}

//   END - ANIMATE.CPP