//	=========================================================================
//	Project...:	kscxms.lib
//	File Name.:	xmsobjs.h
// Date......:	October 17, 1994
//	Version...:	6.2
//	COPYRIGHT (c) 1994 by Kenneth S. Cascio.  All Rights Reserved
//	=========================================================================

#ifndef	__XMSOBJS_H
#define	__XMSOBJS_H

#define	NOXMSOBJ

#include <xmsmain.h>

template<class T>
void XMSOBJS<T>::verify(int level)
{
	if (!access) error(ERR_NOACCESS);

	switch (level) {
		case 0:
			if (!tSubs) error(ERR_NOTARRAY);
			if (!(access->status)) error(ERR_STATUS);

			break;

		case 1:
			if (!(access->status)) error(ERR_STATUS);
			if ((access->frameSize) == 0) error(ERR_FRAMESIZE);

			break;
	}
}

template<class T>
XMSOBJS<T>::XMSOBJS()
{
	tVars = 0;
	tSubs = NULL;
	tItem = 0;

	access = new XMSACCESS();
	if (!access) error(ERR_NEWACCESS);

	object = new T[(access->frameSize)];
	if (!object) error(ERR_OBJECT);

	(access->frame) = (void huge *)object;
}

template<class T>
XMSOBJS<T>::XMSOBJS(unsigned long m)
{
	tVars = 1;
	tSubs = new unsigned long[tVars][2];
	if (!tSubs) error(ERR_TSUBS);
		tSubs[0][0] = m - 1;
		tSubs[0][1] = 1;
	tItem = 0;

	access = new XMSACCESS();
	if (!access) error(ERR_NEWACCESS);

	(access->frameSize) = FrameSize;
	(access->elements) = m;
	(access->checkFrame)(sizeof(T));

	object = new T[(access->frameSize)];
	if (!object) (access->frameSize) = 0;
	(access->frame) = (void huge *)object;

	if (!(access->allocate)(sizeof(T))) error(ERR_ALLOCATE);
}

template<class T>
XMSOBJS<T>::XMSOBJS(unsigned long m, unsigned long n)
{
	tVars = 2;
	tSubs = new unsigned long[tVars][2];
	if (!tSubs) error(ERR_TSUBS);
		tSubs[0][0] = m - 1;
		tSubs[0][1] = n;
		tSubs[1][0] = n - 1;
		tSubs[1][1] = 1;
	tItem = 0;

	access = new XMSACCESS();
	if (!access) error(ERR_NEWACCESS);

	(access->frameSize) = FrameSize;
	(access->elements) = (m * n);
	(access->checkFrame)(sizeof(T));

	object = new T[(access->frameSize)];
	if (!object) (access->frameSize) = 0;
	(access->frame) = (void huge *)object;

	if (!(access->allocate)(sizeof(T))) error(ERR_ALLOCATE);
}

template<class T>
XMSOBJS<T>::XMSOBJS(unsigned long m, unsigned long n, unsigned long o)
{
	tVars = 3;
	tSubs = new unsigned long[tVars][2];
	if (!tSubs) error(ERR_TSUBS);
		tSubs[0][0] = m - 1;
		tSubs[0][1] = (n * o);
		tSubs[1][0] = n - 1;
		tSubs[1][1] = o;
		tSubs[2][0] = o - 1;
		tSubs[2][1] = 1;
	tItem = 0;

	access = new XMSACCESS();
	if (!access) error(ERR_NEWACCESS);

	(access->frameSize) = FrameSize;
	(access->elements) = (m * n * o);
	(access->checkFrame)(sizeof(T));

	object = new T[(access->frameSize)];
	if (!object) (access->frameSize) = 0;
	(access->frame) = (void huge *)object;

	if (!(access->allocate)(sizeof(T))) error(ERR_ALLOCATE);
}

template<class T>
XMSOBJS<T>::XMSOBJS(unsigned long m, unsigned long n, unsigned long o,
	unsigned long p)
{
	tVars = 4;
	tSubs = new unsigned long[tVars][2];
	if (!tSubs) error(ERR_TSUBS);
		tSubs[0][0] = m - 1;
		tSubs[0][1] = (n * o * p);
		tSubs[1][0] = n - 1;
		tSubs[1][1] = (o * p);
		tSubs[2][0] = o - 1;
		tSubs[2][1] = p;
		tSubs[3][0] = p - 1;
		tSubs[3][1] = 1;
	tItem = 0;

	access = new XMSACCESS();
	if (!access) error(ERR_NEWACCESS);

	(access->frameSize) = FrameSize;
	(access->elements) = (m * n * o * p);
	(access->checkFrame)(sizeof(T));

	object = new T[(access->frameSize)];
	if (!object) (access->frameSize) = 0;
	(access->frame) = (void huge *)object;

	if (!(access->allocate)(sizeof(T))) error(ERR_ALLOCATE);
}

template<class T>
XMSOBJS<T>::XMSOBJS(unsigned long m, unsigned long n, unsigned long o,
	unsigned long p, unsigned long q)
{
	tVars = 5;
	tSubs = new unsigned long[tVars][2];
	if (!tSubs) error(ERR_TSUBS);
		tSubs[0][0] = m - 1;
		tSubs[0][1] = (n * o * p * q);
		tSubs[1][0] = n - 1;
		tSubs[1][1] = (o * p * q);
		tSubs[2][0] = o - 1;
		tSubs[2][1] = (p * q);
		tSubs[3][0] = p - 1;
		tSubs[3][1] = q;
		tSubs[4][0] = q - 1;
		tSubs[4][1] = 1;
	tItem = 0;

	access = new XMSACCESS();
	if (!access) error(ERR_NEWACCESS);

	(access->frameSize) = FrameSize;
	(access->elements) = (m * n * o * p * q);
	(access->checkFrame)(sizeof(T));

	object = new T[(access->frameSize)];
	if (!object) (access->frameSize) = 0;
	(access->frame) = (void huge *)object;

	if (!(access->allocate)(sizeof(T))) error(ERR_ALLOCATE);
}

template<class T>
XMSOBJS<T>::~XMSOBJS()
{
	if (access) {
		if (access->status) (access->release)();
		delete access;
	}

	if (tSubs) delete[] tSubs;

	if (object) delete[] object;
}

template<class T>
T far *XMSOBJS<T>::operator[](unsigned long m)
{
	verify(1);

	if (m < (access->elements)) {
		tItem = m;
	} else {
		error(ERR_SUBRANGE);
	}

	return &(object[(access->scope)(tItem, Alter)]);
}

template<class T>
T far *XMSOBJS<T>::operator()(unsigned long m)
{
	verify(1);

	if (tVars != 1) error(ERR_TVARS);
	if (m > tSubs[0][0]) error(ERR_SUBRANGE);

	tItem = m;

	return &(object[(access->scope)(tItem, Alter)]);
}

template<class T>
T far *XMSOBJS<T>::operator()(unsigned long m, unsigned long n)
{
	verify(1);

	if (tVars != 2) error(ERR_TVARS);
	if (m > tSubs[0][0]) error(ERR_SUBRANGE);
	if (n > tSubs[1][0]) error(ERR_SUBRANGE);

	tItem = (m * tSubs[0][1]) + (n * tSubs[1][1]);

	return &(object[(access->scope)(tItem, Alter)]);
}

template<class T>
T far *XMSOBJS<T>::operator()(unsigned long m, unsigned long n,
	unsigned long o)
{
	verify(1);

	if (tVars != 3) error(ERR_TVARS);
	if (m > tSubs[0][0]) error(ERR_SUBRANGE);
	if (n > tSubs[1][0]) error(ERR_SUBRANGE);
	if (o > tSubs[2][0]) error(ERR_SUBRANGE);

	tItem = (m * tSubs[0][1]) + (n * tSubs[1][1]) + (o * tSubs[2][1]);

	return &(object[(access->scope)(tItem, Alter)]);
}

template<class T>
T far *XMSOBJS<T>::operator()(unsigned long m, unsigned long n,
	unsigned long o, unsigned long p)
{
	verify(1);

	if (tVars != 4) error(ERR_TVARS);
	if (m > tSubs[0][0]) error(ERR_SUBRANGE);
	if (n > tSubs[1][0]) error(ERR_SUBRANGE);
	if (o > tSubs[2][0]) error(ERR_SUBRANGE);
	if (p > tSubs[3][0]) error(ERR_SUBRANGE);

	tItem = (m * tSubs[0][1]) + (n * tSubs[1][1]) + (o * tSubs[2][1]) +
		(p * tSubs[3][1]);

	return &(object[(access->scope)(tItem, Alter)]);
}

template<class T>
T far *XMSOBJS<T>::operator()(unsigned long m, unsigned long n,
	unsigned long o, unsigned long p, unsigned long q)
{
	verify(1);

	if (tVars != 5) error(ERR_TVARS);
	if (m > tSubs[0][0]) error(ERR_SUBRANGE);
	if (n > tSubs[1][0]) error(ERR_SUBRANGE);
	if (o > tSubs[2][0]) error(ERR_SUBRANGE);
	if (p > tSubs[3][0]) error(ERR_SUBRANGE);
	if (q > tSubs[4][0]) error(ERR_SUBRANGE);

	tItem = (m * tSubs[0][1]) + (n * tSubs[1][1]) + (o * tSubs[2][1]) +
		(p * tSubs[3][1]) + (q * tSubs[4][1]);

	return &(object[(access->scope)(tItem, Alter)]);
}

template<class T>
char XMSOBJS<T>::success(void)
{
	return ((access->status) && (access->frameSize));
}

template<class T>
int XMSOBJS<T>::loadMethod(ORIENTATION method)
{
	verify(0);

	if (method != Check) (access->orientation) = method;

	return (access->orientation);
}

template<class T>
int XMSOBJS<T>::frameSize(int newSize)
{
	verify(0);

	int oldFrameSize = (access->frameSize);

	if (newSize < 0) return (access->frameSize);
	if (newSize == (access->frameSize)) return (access->frameSize);
	if (newSize > (access->elements)) return (access->frameSize);

	if (object) {
		(access->saveFrame)();
		delete[] object;
	}

	object = NULL;
	(access->frame) = NULL;
	(access->frameSize) = newSize;

	if (newSize > 0) {
		(access->checkFrame)(sizeof(T));
		object = new T[(access->frameSize)];
		if (!object) {
			(access->frameSize) = oldFrameSize;
			object = new T[oldFrameSize];
			if (!object) (access->frameSize) = 0;
		}
		(access->frame) = (void huge *)object;
		(access->scope)(0);
	}

	return (access->frameSize);
}

template<class T>
char XMSOBJS<T>::copy(int direction, void huge *memPtr,
	unsigned long bytes, unsigned long offset)
{
	verify(0);

	if ((access->copy)(direction, memPtr, bytes, offset)) {
		return TRUE;
	} else {
		return FALSE;
	}
}

template<class T>
void XMSOBJS<T>::kill(void)
{
	if (!access) error(ERR_NOACCESS);

	if (access->status) (access->release)();
	delete access;
	access = NULL;

	if (tSubs) {
		delete[] tSubs;
		tSubs = NULL;
	}

	if (object) {
		delete[] object;
		object = NULL;
		(access->frame) = NULL;
	}
}

#endif	//	__XMSOBJS_H

#undef	NOXMSOBJ