/*******************************************************************/
/*******************************************************************/
/*                 I P X / S P X   R O U T I N E S                 */
/*******************************************************************/
/*******************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <mem.h>

#include "rkipx.h"

/*******************************************************************/
/*******************************************************************/

/* function prototypes */

short main( short argc, char *argv[] );
void ShowInstructions( void );

/*******************************************************************/
/*******************************************************************/
/* main program test code */
/*******************************************************************/
/*******************************************************************/

short main( short argc, char *argv[] )
{

unsigned rc;
NETADDR  netaddr;
long     len;
BYTE     *TxBfr;

if ( argc < (6+1) ) // mode, file, txsock, dnet, dnode, dsock, bufsize
   {
   ShowInstructions();
   return( -1 );
   }

if ( !(xatoxb( netaddr.INA.Network, argv[4] )) )
   {
   printf( "Bad Network Addr: %s\n", argv[4] );
   return( -1 );
   }

if ( !(xatoxb( netaddr.INA.Node, argv[5] )) )
   {
   printf( "Bad Node Addr: %s\n", argv[5] );
   return( -1 );
   }

if ( !(xatoxb( netaddr.Socket, argv[6] )) )
   {
   printf( "Bad Socket Addr: %s\n", argv[6] );
   return( -1 );
   }

/* -------------- */
/* Sending a file */
/* -------------- */
if ( toupper( argv[1][0] ) == 'F' )
   {
   printf( "\nATTEMPTING FILE SEND\n" );
   len = 0;
   rc = IPXSendRT( &len, argv[2], argv[3], &netaddr, NULL );
   if ( rc != GOOD_IPX_RETURN )
      {
      printf( "\n" );
      printf( "FUNCTION ERROR: %02X\n", rc );
      printf( "  IPXAPI ERROR: %02X\n", IPXerrno );
      return( -1 );
      }
   printf( "\nSUCCESSFUL FILE SEND\n" );
   }


/* ---------------- */
/* Sending a buffer */
/* ---------------- */

if ( toupper( argv[1][0] ) == 'B' && argc == 8 )
   {
   printf( "\nATTEMPTING BUFFER SEND\n" );
   len = atol( argv[7] );
   TxBfr = farcalloc( 1, len );
   if ( !TxBfr )
      {
      printf( "MEMORY ALLOCATION PROBLEM" );
      return( -1 );
      }
  memset( TxBfr, '!', len );

   rc = IPXSendRT( &len, TxBfr, argv[3], &netaddr, NULL );
   if ( rc != GOOD_IPX_RETURN )
      {
      printf( "\n" );
      printf( "FUNCTION ERROR: %02X\n", rc );
      printf( "  IPXAPI ERROR: %02X\n", IPXerrno );
      farfree( TxBfr );
      return( -1 );
      }
   printf( "\nSUCCESSFUL BUFFER SEND\n" );
   farfree( TxBfr );
   }

return( 0 );
}

/*******************************************************************/
/*******************************************************************/
void ShowInstructions( void )
{
printf( "\n\n\n" );
printf( "ͻ\n" );
printf( " IPX File Transfer Utility version 1.2  RK  6 Jun 92 \n" );
printf( "   (c) 1992 by R. Kvinnesland                        \n" );
printf( "                                                     \n" );
printf( " USE:  IPXFTX p1 p2 p3 p4 p5 p6 p7                   \n" );
printf( "       where p1 = 'B'(uffer) or 'F'(ile)             \n" );
printf( "             p2 = name of file                       \n" );
printf( "             p3 = source socket (4 hex digits)       \n" );
printf( "             p4 = dest network address (8 hex)       \n" );
printf( "             p5 = dest node address (12 hex)         \n" );
printf( "             p6 = dest socket address (4 hex)        \n" );
printf( "             p7 = size of buffer                     \n" );
printf( "                                                     \n" );
printf( " EXAMPLES:                                           \n" );
printf( "                                                     \n" );
printf( " IPXFTX F fi.dat 0420 00000000 12A5C7BB3F02 4010 <CR>\n" );
printf( " IPXFTX B x 0420 00000000 12A5C7BB3F02 4010 2000 <CR>\n" );
printf( "                                                     \n" );
printf( "ͼ\n" );
printf( "\n\n\n\n" );
return;
}

/************************************************************************/
/* EOF  EOF  EOF  EOF  EOF  EOF  EOF  EOF  EOF  EOF  EOF  EOF  EOF  EOF */
/************************************************************************/
