/*
 * INDEX.H - definitions for index package.
 *
 *                      Copyright (C) 1987, Jim Mischel
 * Modifications:
 *
 * 08/13/87 - jim - original coding
 * 11/04/87 - jim - update prototype for iopen() {remove keytyp parameter}
 *                  remove #define's for key types
 *		    add I_NOCMP error code
 * 02/02/88 - jim - add prototypes for idump() and irebuild()
 */

/* conditions for istart() */
#define START_FILE        0
#define LT                1
#define LE                2
#define EQ                3
#define GE                4
#define GT                5
#define END_FILE          6

/* values returned in ierrno */
#define I_NODAT 0x10
#define I_DATRD 0x11
#define I_DATWT 0x12
#define I_NOINX 0x20
#define I_INXRD 0x21
#define I_INXWT 0x22
#define I_INVKEY 0x80
#define I_NOMEM 0x81
#define I_NOREC 0x82
#define I_NOCMP 0x83

/* global variables */
#ifndef __INDEX__
extern int ierrno;
#endif

/* user-callable routines */

void *iopen(char *fname, unsigned recsiz, unsigned offset,
            char dupflag, int (*cmp_rtn)());
void iclose(void *db_control);
int iread(void *db_control, void *destin);
int istart(void *db_control, char cond, void *source);
int iread_next(void *db_control, void *destin);
int iread_prev(void *db_control, void *destin);
int iwrite(void *db_control, void *source);
int irewrite(void *db_control, void *source);
int idelete(void *d, void *src);
int irebuild (char *old_fname, unsigned rec_size, unsigned offset,
	      char dupflag, int (*cmp_rtn)(), char *new_fname);
