/*
 * IBLD.C - build indexed file for testing of irebuild() function.
 *
 *                      Copyright (c) 1988, Jim Mischel
 * Modifications:
 *
 * 02/01/88 - jim - initial coding
 *
 */

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>

#include "index.h"

typedef struct {
  unsigned key;
} key_rec;

#define BUILD_KEYS 100
#define SAVE_KEYS 10

void list_forward(void);
void list_backward(void);
int icmp_uint(void *arg1, void *arg2);

char *key_file;                 /* file descriptor for indexed file routines */
key_rec k;

int main()
{
  unsigned offset = 0;
  int x;
  int ks[SAVE_KEYS];
  
  unlink("NEWKEY.DAT");
  unlink("NEWKEY.INX");
  unlink("KEY.DAT");
  unlink("KEY.INX");
  
  if ((key_file = iopen("KEY",sizeof(key_rec),offset,1,icmp_uint)) == NULL) {
    printf("\nCannot open key file \n");
    printf("Error status is %X\n",ierrno);
    return(1);
  }

  /* build a file of 100 random numbers */
  for (x=0; x < BUILD_KEYS; x++) {
      k.key = rand();
      printf("%8d",k.key);
      if (x < SAVE_KEYS)
        ks[x] = k.key;
      if (iwrite(key_file,&k)) {
        printf("write error");
        return(1);
      }
  }
  printf("\nBefore...\n");
  list_forward();
  list_backward();

  /* delete keys */
  for (x=0; x < SAVE_KEYS; x++) {
    k.key = ks[x];
    printf("Delete %d\n",k.key);
    if (iread(key_file,&k)) {
      printf("read error");
      return(1);
    }
    if (idelete(key_file,&k)) {
      printf("delete error\n");
      return(1);
    }
  }

  printf("\nAfter...\n");
  list_forward();
  list_backward();

  iclose(key_file);
  if (irebuild("KEY",sizeof(key_rec),offset,1,icmp_uint,"NEWKEY")) {
    printf("Error rebuilding file");
    return(1);
  }

  if ((key_file = iopen("NEWKEY",sizeof(key_rec),offset,1,icmp_uint)) == NULL) {
    puts("Error opening NEWKEY");
    return(1);
  }
  list_forward();
  list_backward();
  iclose(key_file);
  return(0);
}

void list_forward(void)
{
  puts("forward list");
  if (istart(key_file,START_FILE,&k)) {
    printf("Error starting file.  Error code is %X\n",ierrno);
    return;
  }
  while (!iread_next(key_file,&k))
    printf("%8d",k.key);
  puts(" ");
}

void list_backward(void)
{
  puts("backward list");
  if (istart(key_file,END_FILE,&k)) {
    printf("Error starting file.  Error code is %X\n",ierrno);
    return;
  }
  while (!iread_prev(key_file,&k))
    printf("%8d",k.key);
  puts(" ");
}

int icmp_uint(void *arg1, void *arg2)
{
  return ((*(unsigned int *)arg1 < *(unsigned int *)arg2) ? -1 :
          (*(unsigned int *)arg1 > *(unsigned int *)arg2) ? 1 : 0);
}
