#include "indent_c.h"
#include "indent_g.h"

dopreesc()
{
        int             in_comment = 0;
        char           *com_start = 0;
        char            quote = 0;
        char           *com_end = 0;

        while (*buf_ptr != '\n' || in_comment) {
                *e_lab = *buf_ptr++;
                if (buf_ptr >= buf_end)
                        fill_buffer();
                switch (*e_lab++) {
                case BACKSLASH:
                        if (troff)
                                *e_lab++ = BACKSLASH;
                        if (!in_comment) {
                                *e_lab++ = *buf_ptr++;
                                if (buf_ptr >= buf_end)
                                        fill_buffer();
                        }
                        break;
                case '/':
                        if (*buf_ptr == '*' && !in_comment && !quote) {
                                in_comment = 1;
                                *e_lab++ = *buf_ptr++;
                                com_start = e_lab - 2;
                        }
                        break;
                case '"':
                        if (quote == '"')
                                quote = 0;
                        break;
                case '\'':
                        if (quote == '\'')
                                quote = 0;
                        break;
                case '*':
                        if (*buf_ptr == '/' && in_comment) {
                                in_comment = 0;
                                *e_lab++ = *buf_ptr++;
                                com_end = e_lab;
                        }
                        break;
                }
        }
        while (e_lab > s_lab && (e_lab[-1] == ' ' || e_lab[-1] == '\t'))
                e_lab--;
        if (e_lab == com_end && bp_save == 0) { /* comment on
                                                 * preprocessor line */
                if (sc_end == 0)        /* if this is the first
                                         * comment, we must set
                                         * up the buffer */
                        sc_end = &(save_com[0]);
                else {
                        *sc_end++ = '\n';       /* add newline between
                                                 * comments */
                        *sc_end++ = ' ';
                        --line_no;
                }
                memcpy(com_start, sc_end, com_end - com_start);
                sc_end += com_end - com_start;
                e_lab = com_start;
                while (e_lab > s_lab && (e_lab[-1] == ' ' || e_lab[-1] == '\t'))
                        e_lab--;
                bp_save = buf_ptr;      /* save current input
                                         * buffer */
                be_save = buf_end;
                buf_ptr = save_com;     /* fix so that
                                         * subsequent calls to
                                         * lexi will take tokens
                                         * out of save_com */
                *sc_end++ = ' ';        /* add trailing blank,
                                         * just in case */
                buf_end = sc_end;
                sc_end = 0;
        }
        *e_lab = '\0';  /* null terminate line */
        ps.pcase = false;
}

