//-------+---------+---------+---------+---------+---------+---------+---------+
// 1991-1992 Betz Associates. Released to the Public Domain. This source code
// is offered without warranty or guarantee of any kind, and the author(s)
// expressly disclaim any responsibility for consequences of it's use in
// products for commercial, shareware, or public domain release of any kind.
//
// File Name: TMRTEST.CPP
// Creation:  September 20, 1992
// Author:    Mark Betz (MB)
//
// Machine:   IBM PC and Compatibles
//
// Includes:  stdio.h, dos.h, types.h, htimer.h
//
//-------+---------+---------+---------+---------+---------+---------+---------+
// Change History
// ------ -------
//
//      Date            Rev.	Author		Purpose
//      ----            ----    ------      -------
//      9-20-1992       1.0     MB          Initial release
//
// Description
// -----------
//      Testbed program for the HTimer hi-resolution timing class
//-------+---------+---------+---------+---------+---------+---------+---------+

#include <stdio.h>
#include <dos.h>

#ifndef __TYPES__
   #include "types.h"
#endif
#ifndef __HTIMER__
   #include "htimer.h"
#endif

dword pulseCounter = 0;                // used in isr to count timer pulses
word cntrVal = 16384;                  // 8254 counter val for high-speed test

void interrupt (*Old08Handler)(...);   // pointer to old timer isr

// **************************************************************************
// >>>>> ISR: Hardware interrupt IRQ 0.  <<<<<
// This function handles interrupts on vector 8, which is mapped to hardware
// IRQ 0. It simply maintains the default frequency of calls to the system
// interrupt 8 handler regardless of the timer frequency

void interrupt NewInt8Handler(...)
   {
   pulseCounter += cntrVal;            // add interrupt rate to counter
   if (pulseCounter > 65535)           // if counter exceeds 65535...
      {
      pulseCounter %= 65535;           // counter = counter % 65535
      Old08Handler();                  // chain old interrupt handler
      }
   else
      outportb(0x20,0x20);             // else send EOI to 8259 PIC

   return;
   }

// *************************************************************************

// This is the main test function

int main()
    {
    dword elapsed;

    printf("**************************************************\r\n");
    printf("***       executing HTimer class testbed       ***\r\n");
    printf("**************************************************\r\n");

    printf("testing bios interrupt elapsed time:\r\n");
    printf("(perfect time = 54945 microseconds)\r\n\r\n");

    printf("=>  testing timer on/off operation...\r\n");
    elapsed = testTimerOnOff();
    printf("=>  time per tick in microsecs: %li\r\n\r\n", elapsed);

    printf("=>  testing timer polling operation...\r\n");
    elapsed = testGetElapsed();
    printf("=>  time per tick in microsecs: %li\r\n\r\n", elapsed);

    printf("testing fast interrupt elapsed time:\r\n");
    printf("(maintaining IRQ 0 interrupt freq. at 18.2 hz.)\r\n\r\n");

    printf("=>  hooking interrupt 8 vector... ");
    Old08Handler = getvect(0x8);
    setvect(0x8, NewInt8Handler);
    printf("hooked\r\n");

    printf("=>  testing timer at 72.8 hz...\r\n");
    elapsed = testFastCount( cntrVal );
    printf("=>  time per tick in microsecs: %li\r\n", elapsed);

    printf("=>  restoring interrupt 8 vector... ");
    setvect(0x8, Old08Handler);
    printf("restored\r\n\r\n");

    printf("**************************************************\r\n");
    printf("***           timer tests completed            ***\r\n");
    printf("**************************************************\r\n");

    return(0);
    }



