#include <stdio.h>
#include <dos.h>
#include <mem.h>
#include <string.h>
#include <stdlib.h>

void	SetGraphicsMode( void );
void	SetTextMode( void );
void	SetDac( char Dac, char Red, char Green, char Blue );
void	GetDac( char Dac, char *Red, char *Green, char *Blue );
void	SetBlock( char Dac, char *Array, char Num );
void	GetBlock( char Dac, char *Array, char Num );
void	SetPoint( int X, int Y, unsigned char Color );
void	GetPoint( int X, int Y, unsigned char *Color );

char far *screen;		// This is the pointer to the graphics screen

void	SetGraphicsMode( void )
{
	asm {
		mov	ax,0x13
    int	0x10
    }
  screen = (char far*)MK_FP( 0xA000, 0 );
}

void	SetTextMode( void )
{
	asm {
  	mov	ax,0x03
    int	0x10;
    }
}

void	SetDac( char Dac, char Red, char Green, char Blue )
{
	asm {
    mov	dh, Red
    mov	ch, Green
    mov	cl, Blue
    mov	ax, 0x1010
    mov	bl, Dac
    int	0x10
    }
}

void	GetDac( char Dac, char *Red, char *Green, char *Blue )
{
	asm {
    mov	ax, 0x1015
    mov	bl, Dac
    int	0x10
    }
    *Red   = _DH;
    *Green = _CH;
    *Blue  = _CL;
}

void	SetBlock( char Dac, char *Array, char Num )
{
	int AS, AO;

	AS = FP_SEG( Array );
  AO = FP_OFF( Array );

  asm {
  	push es
    mov	ax, AS
    mov	es, ax
    mov	dx, AO
    xor	ch, ch
    mov	cl, Num
    mov ax, 0x1012
    xor	bh, bh
    mov	bl, Dac
    int	0x10
    pop	es
    }
}

void	GetBlock( char Dac, char *Array, char Num )
{
	int AS, AO;

	AS = FP_SEG( Array );
  AO = FP_OFF( Array );

  asm {
  	push 	es
    mov	ax, AS
    mov	es, ax
    mov	dx, AO
    xor	ch, ch
    mov	cl, Num
    mov	ax, 0x1017
    xor	bh, bh
    mov	bl, Dac
    int	0x10
    pop	es
    }
}

void	SetPoint( int X, int Y, unsigned char Color )
{
	asm {
    push 	ds			/* Save registers */
    push 	bx
    mov	ax,Y                    /* Get the Y value */
    mov	cx,320
    mul	cx                      /* Multiply by 320 */
    mov	bx,X
    add	ax,bx
    mov	bx,ax
    mov	ax,0xA000               /* Get the offset of */
    mov	ds,ax                   /* video memory into DS */
    mov	al, Color
    mov	[ds:bx],al              /* And put the color there */
    pop	bx                      /* Retrieve registers */
    pop	ds
    }
}

void	GetPoint( int X, int Y, unsigned char *Color )
{
	asm {
    mov	ax,Y                    /* Get the Y value */
    mov	cx,320
    mul	cx                      /* Multiply by 320 */
    mov	bx,X
    add	ax,bx                   /* Add X Offset */
    push	ax
    mov	ax,0xA000               /* Get the offset of */
    mov	es,ax                   /* video memory into DS */
    pop	bx
    mov	al,es:[bx]              /* Get the color */
    }
  *Color = _AL;
}

void VLine( int X, int Ys, int Ye, char Col ) {
	int	pos;
  char *dst;

  dst = screen+(Ys*320)+X;
  for ( pos = Ys; pos < Ye; pos++ ) {
    *dst = Col;
    dst += 320;
    }
}

