/****************************************************************************

    Module  : Main.c

    Version : v1.0alpha

    Date    : 20/8/93

    Changes : None.


*****************************************************************************/

/****************************************************************************

    FUNCTION: WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                      LPSTR lpszCmdParam, int nCmdShow)

    VERSION : v1.0

    PURPOSE : Defines and registers window classes. Creates all windows for
              the application. Then enters a loops which process all the
              messages for the application

    MESSAGES: None specific to this function.

    COMMENTS: Window handles declared as global to allow inter-window message
              passing.
                hwndDock    - Dock window.

****************************************************************************/

#include <windows.h>
#include <stdlib.h>
#include <ctype.h>
#include <bwcc.h>
#include "freedock.h"

/**************************************************************************
 * Set the name of the application                                        *
 **************************************************************************/

char           *szAppName = "FreeDock v1.0";
char           *IniFile = "freedock.ini";
SLOT_ENTRY     *Slot;
SLOT_ENTRY     TmpSlot;
MAIN_OPTIONS   DockOptions;
int            CurSlot;
HANDLE	       hAppInst;
HWND           hwndDock;

#pragma argsused
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
    MSG       msg;
    WNDCLASS  wcDockClass;
    int       nDockX, nDockY, nDockW, nDockH;
    char      TmpBuffer[TMP_BUFF_LEN];

    /*****************************************************************************
        Test to make sure this is the only copy of this application running
        on this machine, if not activate previous instance and exit
    *****************************************************************************/
    if (hPrevInstance) {
	 ShowWindow( hPrevInstance, SW_SHOW );
         exit (-1);
    }

	 LoadLibrary("BWCC.DLL");

    /*********************************************
	  * define and register the dock window class *
     *********************************************/

    wcDockClass.style = CS_DBLCLKS;
    wcDockClass.lpfnWndProc = (WNDPROC) DockWinProc;
    wcDockClass.cbClsExtra = 0;
    wcDockClass.cbWndExtra = 0;
    wcDockClass.hInstance = hInstance;
    wcDockClass.hIcon = LoadIcon(hInstance, szAppName);
    wcDockClass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wcDockClass.hbrBackground = GetStockObject(LTGRAY_BRUSH);
    wcDockClass.lpszMenuName = NULL;
    wcDockClass.lpszClassName = szAppName;

    if(!RegisterClass(&wcDockClass)) return FALSE;

    hAppInst = hInstance;

    /*************************************************************
       Determine the size of the screen, used to size and
       position the window.
    *************************************************************/
    DockOptions.ScreenWidth = GetSystemMetrics(SM_CXSCREEN);
    DockOptions.ScreenHeight = GetSystemMetrics(SM_CYSCREEN);

    /*************************************************************
       Determine the position and alignment of the dock window
       Round dock size down to nearest whole number
    *************************************************************/
   	GetPrivateProfileString("Main Options", "Position", "Right", TmpBuffer, TMP_BUFF_LEN, IniFile);
    switch(toupper(TmpBuffer[0])){
        case 'L': DockOptions.Position = DOCK_LEFT;
                  nDockX = 0;
                  nDockY = 0;
                  nDockH = DockOptions.ScreenHeight;
                  nDockW = SLOT_BUTTON_WIDTH;
                  break;
        case 'T': DockOptions.Position = DOCK_TOP;
                  nDockX = 0;
                  nDockY = 0;
                  nDockH = SLOT_BUTTON_HEIGHT;
                  nDockW = DockOptions.ScreenWidth;
                  break;
        case 'B': DockOptions.Position = DOCK_BOTTOM;
                  nDockX = 0;
                  nDockY = DockOptions.ScreenHeight - SLOT_BUTTON_HEIGHT;
                  nDockH = SLOT_BUTTON_HEIGHT;
                  nDockW = DockOptions.ScreenWidth;
                  break;
        default : DockOptions.Position = DOCK_RIGHT;
                  nDockX = DockOptions.ScreenWidth - SLOT_BUTTON_WIDTH;
                  nDockY = 0;
                  nDockH = DockOptions.ScreenHeight;
                  nDockW = SLOT_BUTTON_WIDTH;
                  break;
    }   

    /*****************************************************
        Calculate the max number of slots which will fit
	on the screen + 1 for partially visible slot.
    *****************************************************/
    DockOptions.DockSize = (DockOptions.ScreenWidth / SLOT_BUTTON_WIDTH) + 1;

    /***********************************
        malloc the memory for the slots
    ***********************************/

    Slot = (SLOT_ENTRY *)calloc(DockOptions.DockSize, sizeof(SLOT_ENTRY));
    if(Slot == NULL){
            MessageBox( NULL, "Free Dock Error",
                                "Cannot allocate memory for dock slots",
                                MB_ICONSTOP | MB_OK); 
            exit(-3);
    }

    /*********************************************
        No need to initialise all slot types to
        being free since SLOT_FREE is 0 and we
        used calloc to get the memory
    *********************************************/

    /**************************
        Read in all slot info
    **************************/

    ReadINIFile(hAppInst, Slot, DockOptions.DockSize);


    /*****************************************
      create and position the dock window
    *****************************************/

    hwndDock = CreateWindow(
			                szAppName,	                /* window class name    */
			                szAppName,	                /* window caption       */
			                WS_VISIBLE | WS_POPUP | WS_BORDER,	/* window style         */
			                nDockX,	                    /* initial x position   */
			                nDockY,	                    /* initial y position   */
			                nDockW+2,	                /* initial x size       */
			                nDockH+2,	                /* initial y size       */
			                NULL,	                    /* parent window handle */
			                NULL,	                    /* window menu handle   */
			                hInstance,	                /* program instance handle */
			                lpszCmdParam	                /* creation parameters  */
                           );

    if(!hwndDock) return FALSE;

    ShowWindow(hwndDock, SW_SHOW);
    UpdateWindow(hwndDock);

    /************************************************
         enter message processing loop
    ************************************************/

    while (GetMessage(&msg, NULL, NULL, NULL)) {
    	TranslateMessage(&msg);
	    DispatchMessage(&msg);
    }

    free(Slot);

    return msg.wParam;		/* exit application */
}
