/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

#ifndef FPCLIB
#define FPCLIB

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

   #define FAR                 far
   #define PTR                 far *
   #define FPENTRY             pascal far

   typedef          char       CHAR;        /* signed     8 bits  */
   typedef unsigned char       BYTE;        /* unsigned   8 bits  */

   typedef          int        INT;         /* signed    16 bits  */
   typedef unsigned int        UINT;        /* unsigned  16 bits  */

   typedef signed   short int  INT2;        /* signed    16 bits  */
   typedef unsigned short int  UINT2;       /* unsigned  16 bits  */
   typedef unsigned int        WORD;        /* unsigned  16 bits  */
   typedef long                INT4;        /* signed    32 bits  */
   typedef unsigned long       UINT4;       /* unsigned  32 bits  */
   typedef float               REAL4;       /* signed    32 bits  */
   typedef double              REAL8;       /* unsigned  64 bits  */
   typedef void                VOID;


   typedef CHAR PTR            PCHAR;        /* signed     8 bits  */
   typedef BYTE PTR            PBYTE;        /* unsigned   8 bits  */

   typedef INT  PTR            PINT;         /* signed    16 bits  */
   typedef UINT PTR            PUINT;        /* unsigned  16 bits  */

   typedef INT2  PTR           PINT2;        /* signed    16 bits  */
   typedef UINT2 PTR           PUINT2;       /* unsigned  16 bits  */
   typedef WORD  PTR           PWORD;        /* unsigned  16 bits  */
   typedef INT4  PTR           PINT4;        /* signed    32 bits  */
   typedef UINT4 PTR           PUINT4;       /* unsigned  32 bits  */
   typedef REAL4 PTR           PREAL4;       /* signed    32 bits  */
   typedef REAL8 PTR           PREAL8;       /* unsigned  64 bits  */
   typedef VOID  PTR           PVOID;

/*---------------------------------------------------------------------
- Data structure for FindFirst, FindNext
---------------------------------------------------------------------*/

typedef struct TFindRec
   {
   BYTE    Attr;
   UINT2   Time;
   UINT2   Date;
   UINT4   Size;
   BYTE    Name[13];
   } TFindRec;

/*---------------------------------------------------------------------
- Global Variables
---------------------------------------------------------------------*/

extern BYTE pascal CErrDevice[10];
extern BYTE pascal CheckSnow;
extern BYTE pascal TextAttr;

extern INT2 pascal VioMode;
extern INT2 pascal VioPage;
extern INT2 pascal VioCols;
extern INT2 pascal VioCursor;
extern INT2 pascal VioBaseSeg;
extern INT2 pascal VioMouse;

extern INT2 pascal WindMin;
extern INT2 pascal WindMax;

extern INT2 pascal InsMode;

extern INT2 pascal DosErrNo;
extern INT2 pascal CErrCode;
extern INT2 pascal CErrType;
extern INT2 pascal CErrDrive;

extern INT2 pascal NEvents;
extern INT2 pascal MTextMode;

extern INT2 pascal MouButtons;

/*---------------------------------------------------------------------
- DOS1 routines
---------------------------------------------------------------------*/

VOID FPENTRY Beep( UINT2 Freq, UINT2 Dur );
VOID FPENTRY GetTime( PINT2 Hour, PINT2 Minute,
                      PINT2 Second, PINT2 Sec100 );

/*---------------------------------------------------------------------
- For FPGetKey.c module
---------------------------------------------------------------------*/

#ifndef IN_GETKEY
   extern INT2 FPENTRY GetKey( VOID );
#endif

/*---------------------------------------------------------------------
- Bios and DOS keyboard routines
---------------------------------------------------------------------*/

VOID  FPENTRY BiosKbdClr( VOID );
INT2  FPENTRY BiosKbdGetElmt( VOID );
INT2  FPENTRY BiosKbdHit( VOID );
VOID  FPENTRY BiosKbdRead( PCHAR Ch );
INT2  FPENTRY BiosKbdStat( VOID );
VOID  FPENTRY DosKbdClr( VOID );
INT2  FPENTRY DosKbdGetElmt( VOID );
INT2  FPENTRY DosKbdHit( VOID );
VOID  FPENTRY DosKbdRead( PCHAR Ch );


UINT2 FPENTRY bkReadCh( VOID );
UINT2 FPENTRY bkGetKbdStatus( VOID );
UINT2 FPENTRY bkGetKbdFlags( VOID );
VOID  FPENTRY bkSetRepeatRate( INT2 Delay, INT2 Repeat );
UINT2 FPENTRY bkPushKeyCodes( INT2 scancode, INT2 ascii );

UINT2 FPENTRY bkeReadCh( VOID );
UINT2 FPENTRY bkeGetKbdStatus( VOID );
UINT2 FPENTRY bkeGetKbdFlags( VOID );

/*---------------------------------------------------------------------
- Bios printer routines
---------------------------------------------------------------------*/

VOID FPENTRY BiosPrtChar( CHAR Ch, INT2 PrtNo );
INT2 FPENTRY BiosPrtInit( INT2 PrtNo );
INT2 FPENTRY BiosPrtStat( INT2 PrtNo );
VOID FPENTRY DosPrtChar( CHAR Ch );

/*---------------------------------------------------------------------
- Video routines
---------------------------------------------------------------------*/

VOID FPENTRY BorderColor( INT Color );
VOID FPENTRY ClrWin( INT x1, INT y1, INT x2, INT y2, INT Attr );
VOID FPENTRY ColorMsg( INT x, INT y, INT Attr, PCHAR Message );
VOID FPENTRY DspMsg( INT x, INT y, PCHAR Message );

VOID FPENTRY EditSt( INT      Row,
                     INT      StCol,
                     INT      SpCol,
                     INT      Len,
                     INT      CharCase,
                     INT      FillCh,
                     INT      AutoSkip,
                     UINT     ErrTone,
                     UINT     ErrDur,
                     PCHAR    VCSet,
                     PCHAR    TCSet,
                     PINT     ChOfs,
                     PINT     TE,
                     PCHAR    St    );

VOID FPENTRY FillColAttr( INT x, INT y, INT NRows, INT Attr );
VOID FPENTRY FillColCell( INT x, INT y, INT NRows, INT Cell );
VOID FPENTRY FillColChar( INT x, INT y, INT NRows, CHAR Ch );

VOID FPENTRY FillFrameAttr( INT x1, INT y1,
                            INT x2, INT y2, INT Attr );

VOID FPENTRY FillFrameCell( INT x1, INT y1,
                            INT x2, INT y2, INT2 Cell );

VOID FPENTRY FillFrameChar( INT x1, INT y1,
                            INT x2, INT y2, CHAR Ch );

VOID FPENTRY FillRowAttr( INT x, INT y, INT NBytes, INT Attr );
VOID FPENTRY FillRowCell( INT x, INT y, INT NWords, INT2 Cell );
VOID FPENTRY FillRowChar( INT x, INT y, INT NBytes, CHAR Ch );

VOID FPENTRY FrameWin( CHAR UL,  CHAR UR,
                       CHAR LL,  CHAR LR,
                       CHAR Hor, CHAR Ver, INT Attr );

INT2 FPENTRY GetCursorSize( VOID );

VOID FPENTRY GetFrameAttr( INT x1, INT y1,
                           INT x2, INT y2, PCHAR Buffer );

VOID FPENTRY GetFrameCell( INT x1, INT y1,
                           INT x2, INT y2, PCHAR Buffer );

VOID FPENTRY GetFrameChar( INT x1, INT y1,
                           INT x2, INT y2, PCHAR Buffer );

VOID FPENTRY GetScrn( INT x, INT y, INT NWords, PVOID Buffer );
INT  FPENTRY GetVideoCols( VOID );

VOID FPENTRY GetVideoInfo( PINT BaseSeg, PINT Cols,
                           PINT Pg,      PINT Mode );

INT  FPENTRY GetVideoMode( VOID );
INT  FPENTRY GetVideoPage( VOID );
VOID FPENTRY GotoxyAbs( INT x, INT y );
VOID FPENTRY HideCursor( VOID );
VOID FPENTRY InitVideo( INT Mode );

VOID FPENTRY PutFrameAttr( INT x1, INT y1,
                           INT x2, INT y2, PCHAR Buffer );

VOID FPENTRY PutFrameCell( INT x1, INT y1,
                           INT x2, INT y2, PCHAR Buffer );

VOID FPENTRY PutFrameChar( INT x1, INT y1,
                           INT x2, INT y2, PCHAR Buffer );

VOID FPENTRY PutScrn( INT x, INT y, INT NWords, PVOID Buffer );
INT  FPENTRY RvsAttr( INT Attr );

VOID FPENTRY ScrollDown( INT x1,   INT y1,
                         INT x2,   INT y2,
                         INT Attr, INT NRows );

VOID FPENTRY ScrollLeft( INT x1,   INT y1,
                         INT x2,   INT y2,
                         INT Attr, INT NCols );

VOID FPENTRY ScrollRight( INT x1,   INT y1,
                          INT x2,   INT y2,
                          INT Attr, INT NCols );

VOID FPENTRY ScrollUp( INT x1,   INT y1,
                       INT x2,   INT y2,
                       INT Attr, INT NRows );

VOID FPENTRY SetCursorSize( INT StScan, INT SpScan );
VOID FPENTRY SetVideoPage( INT PageNo );
VOID FPENTRY ShowCursor( VOID );
VOID FPENTRY VioInit( VOID );
INT  FPENTRY WhereXAbs( VOID );
INT  FPENTRY WhereYAbs( VOID );
VOID FPENTRY WindowFP( INT x1, INT y1, INT x2, INT y2 );
VOID FPENTRY WriteSt( PCHAR String );
VOID FPENTRY WriteStln( PCHAR String );

/*---------------------------------------------------------------------
- Intel chip routines
---------------------------------------------------------------------*/

UINT  FPENTRY GetFP_OFF( PVOID address );
UINT  FPENTRY GetFP_SEG( PVOID address );
PVOID FPENTRY MakeFP( UINT seg, UINT ofs );

/*---------------------------------------------------------------------
- DISK routines
---------------------------------------------------------------------*/

VOID  FPENTRY CloseFile( INT2 Handle );
VOID  FPENTRY CreateFile( PCHAR Path, INT2 Attr, PINT2 Handle );

VOID  FPENTRY DosFindFirst( PCHAR  Path,
                            INT2      Attr,
                            TFindRec  FindRec );

VOID  FPENTRY DosFindNext( TFindRec FindRec );
UINT4 FPENTRY FSeek( INT Handle, INT Orgin, INT4 Offset );
INT2  FPENTRY GetDrive( VOID );
VOID  FPENTRY GetDTA( UINT2 Segment, UINT2 Offset );
INT4  FPENTRY GetFileSize( INT Handle );
INT2  FPENTRY GetNDrvs( VOID );
VOID  FPENTRY OpenFile( PCHAR Path, INT2 Attr, PINT2 Handle );

VOID  FPENTRY ReadFile( INT2   Handle,
                        INT2   NBytes,
                        PCHAR  Buffer,
                        PUINT2 RBytes );

VOID  FPENTRY ResetDisk( VOID );
VOID  FPENTRY ResetErrCodes( VOID );
VOID  FPENTRY RestInt24( VOID );
VOID  FPENTRY SetDTA( UINT2 Segment, UINT2 Offset );
VOID  FPENTRY SetInt24( VOID );

VOID  FPENTRY WriteFile( INT2   Handle,
                         INT2   NBytes,
                         PCHAR  Buffer,
                         PUINT2 WBytes );

/*---------------------------------------------------------------------
- BIOS mouse routines
---------------------------------------------------------------------*/

INT2  FPENTRY MButtonPress( INT2  Button,
                            PINT2 ButPress,
                            PINT2 x,
                            PINT2 y  );

INT2  FPENTRY MButtonRel( INT2  Button,
                          PINT2 ButPress,
                          PINT2 x,
                          PINT2 y  );

VOID  FPENTRY MGetPos( PINT2 Button, PINT2 x, PINT2 y );
VOID  FPENTRY MGetSpeed( PINT2 HorCnt, PINT2 VerCnt );

VOID  FPENTRY MGraphCursor( INT2  XHotSpot, INT2  YHotSpot,
                            UINT2 CMaskSeg, UINT2 CMaskOfs );

VOID  FPENTRY MHideCursor( VOID );
VOID  FPENTRY MInitEventHandler( INT2 EventMask );

VOID  FPENTRY MPollQue( PINT2 Event, PINT2 ButStat,
                        PINT2 x,     PINT2 y      );

INT2  FPENTRY MResetMouse( PINT2 NBut );

VOID  FPENTRY MRetQue( PINT2 Event, PINT2 ButStat,
                       PINT2 x,     PINT2 y      );

VOID  FPENTRY MSetEvent( INT2 Event, INT2 ButStat, INT2 x, INT2 y );

VOID  FPENTRY MSetPos( INT2 x, INT2 y );
VOID  FPENTRY MSetSpeed( INT2 HorCnt, INT2 VerCnt );
VOID  FPENTRY MSetXRange( INT2 Min, INT2 Max );
VOID  FPENTRY MSetYRange( INT2 Min, INT2 Max );
VOID  FPENTRY MShowCursor( VOID );
VOID  FPENTRY MTextCursor( INT2 CType, INT2 SMask, INT2 CMask );

/*---------------------------------------------------------------------
- BIOS video routines
---------------------------------------------------------------------*/

VOID  FPENTRY bvSetMode( INT2 Mode, INT2 Clear );
VOID  FPENTRY bvSetCurType( INT2 StScan, INT2 SpScan );
VOID  FPENTRY bvSetCurPos( INT2 pg, INT2 row, INT2 col );
VOID  FPENTRY bvGetCurPos( INT2 pg, PINT2 row, PINT2 col );
VOID  FPENTRY bvGetCurType( INT2 pg, PINT2 stscan, PINT2 spscan );
VOID  FPENTRY bvSetPage( INT2 pg );

VOID  FPENTRY bvScrollDn( INT2 top,    INT2 left,
                          INT2 bottom, INT2 right,
                          INT2 lines,  INT2 attr );

VOID  FPENTRY bvScrollUp( INT2 top,    INT2 left,
                          INT2 bottom, INT2 right,
                          INT2 lines,  INT2 attr );

VOID  FPENTRY bvReadCell( PINT2 ch, PINT2 attr, INT2 pg );

VOID  FPENTRY bvWrtNCell( INT2 ch,    INT2 attr,
                          INT2 count, INT2 pg   );

VOID  FPENTRY bvWrtNChar( INT2 ch, INT2 count, INT2 pg );
VOID  FPENTRY bvSetState0B( INT2 color );
VOID  FPENTRY bvWrtPix( INT2 row, INT2 col, INT2 pixval, INT2 pg );
INT2  FPENTRY bvReadPix( INT2 row, INT2 col, INT2 pg );
VOID  FPENTRY bvWrtTTYChar( INT2 ch, INT2 pg, INT2 color );
VOID  FPENTRY bvGetMode( PINT2 mode, PINT2 cols, PINT2 pg );
VOID  FPENTRY bvSetPalReg( INT2 color, INT2 reg );
VOID  FPENTRY bvSetBorder( INT2 color );
VOID  FPENTRY bvSetPalBorder( CHAR list[17] );
VOID  FPENTRY bvSetBlink( INT2 state );
INT2  FPENTRY bvGetPalReg( INT2 reg );
INT2  FPENTRY bvGetBorder( VOID );
VOID  FPENTRY bvGetPalBorder( CHAR buf[17] );

VOID  FPENTRY bvSetColorReg( UINT2 colorreg, INT2 green,
                             INT2  blue,     INT2 red );

VOID  FPENTRY bvSetColorRegBlk( UINT2 startreg,
                                INT2  regcount,
                                BYTE  colortbl[][3] );

VOID  FPENTRY bvSetColorPgMode( INT2 pgstate );
VOID  FPENTRY bvSetColorRegPg( INT2 pg );

VOID  FPENTRY bvGetColorReg( INT2  colorreg, PINT2 green,
                             PINT2 blue, PINT2 red );

VOID  FPENTRY bvGetColorRegBlk( UINT2 startreg,
                                INT2  regcount,
                                BYTE   colortbl[][3] );

VOID  FPENTRY bvGetColorPgMode( PINT2 colorpg, PINT2 pgmode );
VOID  FPENTRY bvSetGrayScale( UINT2 startreg, INT2  regcount );

VOID  FPENTRY bvLoadUsrFont00( INT2  pts,     INT2  block,
                               UINT2 chcount, UINT2 startch,
                               PVOID fonttbl );

VOID  FPENTRY bvLoadUsrFont10( INT2  pts,     INT2  block,
                               UINT2 chcount, UINT2 startch,
                               PVOID fonttbl );

VOID  FPENTRY bvLoad8x14Font01( INT2  block );
VOID  FPENTRY bvLoad8x14Font11( INT2  block );
VOID  FPENTRY bvLoad8x8Font02( INT2  block );
VOID  FPENTRY bvLoad8x8Font12( INT2  block );
VOID  FPENTRY bvSetBlkSpec( INT2  block );
VOID  FPENTRY bvLoad8x16Font04( INT2  block );
VOID  FPENTRY bvLoad8x16Font14( INT2  block );
VOID  FPENTRY bvSet1FhFontPtr( PVOID  fonttbl );

VOID  FPENTRY bvSet43hUsrFont( INT2 rows,   UINT2 points,
                               INT2 scnrows, PVOID  fonttbl );

VOID  FPENTRY bvSet43h8x14Font( INT2 rows, INT2 scnrows   );
VOID  FPENTRY bvSet43h8x8Font( INT2 rows, INT2 scnrows   );
VOID  FPENTRY bvSet43h8x16Font( INT2 rows, INT2 scnrows   );

VOID  FPENTRY bvGetFontInfo( INT2  fontcode, PUINT2 points,
                             PINT2 scnrows, PVOID   fonttbl );

VOID  FPENTRY bvGetConfigInfo( PINT2 dsptype, PINT2 egamem,
                               PINT2 fbits,   PINT2 swset );

VOID  FPENTRY bvSetAltPrtSc( VOID );
INT2  FPENTRY bvSetScanLines( INT2 scancode );
INT2  FPENTRY bvDefPalLoad( INT2 setting );
INT2  FPENTRY bvVioAccess( INT2 setting );
INT2  FPENTRY bvGrayScaleSum( INT2 setting );
INT2  FPENTRY bvCurEmulation( INT2 setting );
VOID  FPENTRY bvSwDsp( INT2 setting, PCHAR buffer );
INT2  FPENTRY bvScnRefresh( INT2 setting );

VOID  FPENTRY bvWrtTTYStr( INT2 mode, INT2 row, INT2 col,
                           INT2 len,  INT2 pg,  INT2 attr,
                           PCHAR st );

INT2  FPENTRY bvGetDspCode( INT2 *ActiveDspCode, INT2 *InactiveDspCode );

/*---------------------------------------------------------------------
- DOS routines
---------------------------------------------------------------------*/

VOID  FPENTRY dDiskReset( VOID );
INT2  FPENTRY dSelectDisk( INT2 Drive );
INT2  FPENTRY dGetCurrentDisk();
VOID  FPENTRY dSetDta( UINT2 Segment, UINT2 Offset );

INT   FPENTRY dGetDriveData( INT2      Drive,
                             PUINT2 Sectors,
                             PUINT2 MediaSeg,
                             PUINT2 MediaOfs,
                             PUINT2 SectorSize,
                             PUINT2 Clusters  );


VOID  FPENTRY dSetIntVec( UINT2 dIntno, UINT2 dSeg, UINT2 dOfs );

VOID  FPENTRY dCreateNewPsp( UINT2 Segment );
VOID  FPENTRY dGetDate( PINT2 Month,
                        PINT2 Day,
                        PINT2 Year,
                        PINT2 DayOfWk );

INT   FPENTRY dSetDate( INT Month, INT Day, INT Year );

VOID  FPENTRY dGetTime( PINT2 Hour,
                        PINT2 Minute,
                        PINT2 Seconds,
                        PINT2 Hundredths );

VOID  FPENTRY dSetTime( INT2 Hour,    INT2 Minute,
                        INT2 Seconds, INT2 Hundredths );

VOID  FPENTRY dSetVerifyFlag( INT2 VerifyOpt );
VOID  FPENTRY dGetDta( PUINT2 Segment, PUINT2 Offset );
VOID  FPENTRY dGetVersion( PINT2 Major, PINT2 Minor );
INT   FPENTRY dGetBreakStatus( VOID );
VOID  FPENTRY dSetBreakFlag( INT flag );
VOID  FPENTRY dGetBusyFlag( PUINT2 dSeg, PUINT2 dOfs );

VOID  FPENTRY dGetIntVec( UINT2 dIntno, PUINT2 dSeg, PUINT2 dOfs );

//void (_cdecl _interrupt _far * _cdecl _dos_getvect(unsigned))();


INT   FPENTRY dGetDrvAllocInfo( UINT     Drive,
                                PUINT Sectors,
                                PUINT AvailClusters,
                                PUINT BytesInSector,
                                PUINT TotalClusters );

INT   FPENTRY dMkDir( PCHAR Path );
INT   FPENTRY dRmDir( PCHAR Path );
INT   FPENTRY dChDir( PCHAR Path );
INT   FPENTRY dCreateFile( PCHAR Path, INT2 Attr, PINT2 Handle );
INT   FPENTRY dOpenFile( PCHAR Path, INT2 Mode, PINT2 Handle );
INT   FPENTRY dCloseFile( PCHAR Path, INT2 Mode, PINT2 Handle );

INT   FPENTRY dReadFile( INT Handle,       UINT2 NBytes,
                         PVOID Buffer,  PUINT2 BytesRead );

INT   FPENTRY dWriteFile( INT Handle,      UINT NBytes,
                          PVOID Buffer, PUINT BytesWritten );

INT   FPENTRY dDelFile( PCHAR FileSpec );
INT   FPENTRY dSetFilePos( INT2 Handle, INT Method, PINT4 Ofs );
INT   FPENTRY dGetFileAttr( PCHAR FileSpec, PINT2 Attr );
INT   FPENTRY dSetFileAttr( PCHAR FileSpec, INT2 Attr );


#ifdef __cplusplus
}
#endif


#endif
