// Header file of the File_cl class (for file objects)

// Amount of simultaneously opened files. DON'T MODIFY
// Modification implies library recompilation
#define MAXFIL_OPEN 17

#include <time.h>

#include "\borlandc\nat\classes\defs.hpp"

#if NAT_FILE_DEBUG
// values for "control" arg of debug() method :
#define DEBUG_ASSIGN 1
// checks object assignation
#define DEBUG_STATUS 2
// status() method call required

extern FILE *ficdbg;	// debugging file (logs calls)
extern int dbg_depth;	// current indentation (column #) in debugging file
#define Dbg_fct_fin	dbg_depth--	// negative indentation macro
#else
#define Dbg_fct_fin ((void)0)
#endif

// builds a pathname
void pascal strcpyNameFile(char *dst, const char *quoi);
// CRC-32 calculation
unsigned long pascal crc_32(const unsigned char *p, unsigned int n, unsigned long crc = 0);
// do not use :
void File_clGiveCore(unsigned long);

#ifdef __BCPLUSPLUS__
void far * _farptr_norm(void *pnt);	// Zortech's huge pointers
#endif

typedef long OFFSET_T;	// offset in file
typedef unsigned char ERRCOD_T;	// error code

// class of file objects
class File_cl
{
 private:
	char privateData[155];	// do not modify (for exact sizeof() calculation)

 public:
	File_cl();
	void classVersion(int *major, int *minor);	// version of File_cl
#if NAT_FILE_DEBUG
	File_cl(const File_cl&);	// copy initializer. DON'T USE
#endif

#if FILE_SECURE
	inline char addSecureFile(const char *name);
	char initSecure(void);
#endif
	char assign(const char *name, const char *mode, int sizebuf=4096, unsigned char flush_frequency=0);
	inline void setAbortOnErr(char s);
	inline char getAbortOnErr(void);

	inline void setUsrErrFct(void (*argusr_err)(const char *, const char*, ...));
	char pascal reinit(void);	// pour rassigner un objet

	OFFSET_T length(size_t *reste=NULL, size_t size_elem=1);
	int fseek(OFFSET_T, int whence, char real=0);
	inline OFFSET_T tell(void) const;
	inline size_t fread(void *ptr, size_t size, size_t n, OFFSET_T o=-1);
	inline size_t fwrite(const void *ptr, size_t size, size_t n, OFFSET_T o=-1);
	int pascal fputc(int c, OFFSET_T off=-1);
	int pascal fgetc(OFFSET_T off=-1);

	char flush(char ouvre=0);
	int pascal flushAll(void);
	inline int eof(void);
	inline int error(void) const;
	inline ERRCOD_T getErrCod(void) const;
	int pascal fclose(void);

	inline const char *getName(void) const;
	inline char isWritable(void) const;
	inline char isReadable(void) const;
	int pascal internFclose(void);
	inline void stayOpen(void);
	inline char isOpen(void) const;
	void setBuf(int size_buf=0);
	void maxBuf(char percent_ram=25);
	char minBuf(long recup_ram=10000000L);
	inline void setVerify(char c=1);
	inline char getVerify(void) const;
	int forceClose(int, char real_fclose=1);
	char pascal setMaxFilesOpen(int x);
	void giveCore(unsigned long howmuch=20000000L);
	File_cl *whatFile_cl(const char *namefile) const;

	int internChmod(const char *path, char func, int attr);
	void setDriveVerify(char drive, char verif=1);
	int pascal unlink(char secure=0);
	char pascal writeGarbage(OFFSET_T zone_size=-1);
	int pascal rename(const char *);
	char getCRC32(unsigned long *crc32, OFFSET_T off=0, OFFSET_T len=0);
	char copy(const char *newname, OFFSET_T start=0, OFFSET_T len=0);
	char copy(File_cl *, OFFSET_T start=0, OFFSET_T len=0);
	char compare(File_cl *other, OFFSET_T *first_dif, OFFSET_T start1=0, OFFSET_T start2=0, OFFSET_T len=0);
	char pascal move(const char *newname);
	char cut(OFFSET_T where=-1, char secure=0);
#if NAT_FILE_DEBUG
	void pascal optimiseBuf(unsigned long core) const;
	void pascal noOptiBuf(void);
	unsigned long status(char complete=1) const;
	inline unsigned long getNbOpensTot(void) const;
#endif
	~File_cl(void);
};
