/*************************************************************************

   This program is shareware. If you use it and find it useful please
   send ($25 is suggested) or whatever you think it is worth to :

			 Raymond P. Wilson
			 38 Paremata St.
			 Atawhai
			 Nelson
			 New Zealand

   If you wish to use this program or parts of this program in a
commercial the authors permission is required.

Copyright Raymond P. Wilson 1989

**************************************************************************/

/* arithmetic coding routines */

/* Most of the functions here have been converted to macro definitions
   to speed them up and customised bor a binary alphabet  */

#define codevaluebits 16
typedef long codevalue ;

#define topvalue (((long)1<<codevaluebits)-1)

#define firstqtr (topvalue/4+1)
#define half     (2*firstqtr)
#define thirdqtr (3*firstqtr)

long		S_bitstofollow=0 ;
int		S_buffer=0;

/*==================================*/

#define bitplusfollow0            \
    { outputbit0 ;                \
      while (S_bitstofollow>0)    \
        { outputbit1 ;            \
          S_bitstofollow--;       \
        }                         \
    }

#define bitplusfollow1            \
    { outputbit1 ;                \
      while (S_bitstofollow>0)    \
        { outputbit0 ;            \
          S_bitstofollow--;       \
        }                         \
    }

#define outputbit0                \
    { S_buffer >>= 1;		  \
      S_bitstogo--;               \
      if (S_bitstogo==0)          \
        { putc(S_buffer, stdout) ;\
          S_bitstogo = 8 ;        \
          cmpbytes++ ;            \
        }                         \
    }

#define outputbit1                \
    { S_buffer = (S_buffer >> 1) | 0x80;            \
      S_bitstogo--;               \
      if (S_bitstogo==0)          \
        { putc(S_buffer, stdout) ;\
          S_bitstogo = 8 ;        \
          cmpbytes++ ;            \
        }                         \
    }

/*==================================*/

#define arithmetic_encode_zero(hbnd, totl)				\
{									\
   S_high = S_low  +  (((long)(S_high-S_low)+1) * hbnd)/totl - 1 ;	\
									\
   for (;;)								\
     { if (S_high<H) 							\
         { bitplusfollow0 ;						\
         }								\
       else								\
       if (S_low>=H) 							\
         { bitplusfollow1 ;						\
           S_low -= H ;							\
           S_high -= H ;						\
         }								\
       else								\
       if (S_low>=firstqtr && S_high<thirdqtr)				\
         { S_bitstofollow++ ;						\
           S_low -= firstqtr ;						\
           S_high -= firstqtr ;						\
         }								\
       else break ;							\
       S_low <<= 1;							\
       S_high = (S_high << 1) | 1;					\
     }									\
  }

/*=====================================================================*/

#define arithmetic_encode_one(lbnd, totl)				\
{									\
   S_low  += ((((long)(S_high-S_low)+1) * lbnd)/totl) ;			\
									\
   for (;;)								\
     { if (S_high<H) 							\
         { bitplusfollow0 ;						\
         }								\
       else								\
       if (S_low>=H) 							\
         { bitplusfollow1 ;						\
           S_low -= H ;							\
           S_high -= H ;						\
         }								\
       else								\
       if (S_low>=firstqtr && S_high<thirdqtr)				\
         { S_bitstofollow++ ;						\
           S_low -= firstqtr ;						\
           S_high -= firstqtr ;						\
         }								\
       else break ;							\
       S_low <<= 1; ;							\
       S_high = (S_high << 1) | 1;					\
     }									\
  }									

/*==================================*/

#define startencoding() 		\
    S_high = topvalue ;

#define doneencoding()			\
  { 					\
    S_bitstofollow++;			\
    if (S_low<firstqtr)			\
{       bitplusfollow0;}		\
    else				\
{       bitplusfollow1; }		\
  }

#define startoutputingbits()		\
    S_bitstogo = 8 ;

#define doneoutputingbits()		\
  { putc(S_buffer>>S_bitstogo, stdout) ;\
    cmpbytes++;				\
  }
