#ifndef __DIB_H__
#define __DIB_H__


// WIDTHBYTES takes # of bits in a scan line and rounds up to nearest
// dword.

#define WIDTHBYTES(bits)      ((((bits) + 31) >> 5) << 2)

#define PALVERSION   0x300

// Given a pointer to a DIB header, return TRUE if is a Windows 3.0 style
// DIB, false if otherwise (PM style DIB).

#define IS_WIN30_DIB(lpbi)  ((*(LPDWORD) (lpbi)) == sizeof (BITMAPINFOHEADER))


VOID      RealizeDIBPalette   (HDC hDC, LPBITMAPINFO lpbmi);
WORD      DIBNumColors        (LPSTR lpbi);
LPSTR     FindDIBBits         (LPSTR lpbi);
WORD      PaletteSize         (LPSTR lpbi);
HPALETTE  CreateDIBPalette    (HANDLE hDIB);
DWORD     DIBHeight           (LPSTR lpDIB);
DWORD     DIBWidth            (LPSTR lpDIB);
HBITMAP   DIBToBitmap         (HANDLE hDIB, HPALETTE hPal);
HANDLE    BitmapToDIB         (HBITMAP hBitmap, HPALETTE hPal);
HGLOBAL   RenderDIBFormat     (HGLOBAL hdib, WORD wBits, DWORD dwComp);
VOID      InitBitmapInfoHeader(LPBITMAPINFOHEADER lpBmInfoHdr, DWORD dwWidth, DWORD dwHeight, int nBPP);

#endif // __DIB_H__
