#ifndef __FILE_H__
#define __FILE_H__

/*--------------  FileOpen Commmon Dialog Box Defines -------------*/

#define IDD_INFO        100
#define IDD_OPTIONS     101

/*--------------  Dib Information Dialog Box Defines --------------*/

#define IDD_NAME        150
#define IDD_FORMAT      151
#define IDD_WIDTH       152
#define IDD_HEIGHT      153
#define IDD_COLORS      154
#define IDD_COMPRESS    155
#define IDD_COMPHEAD    156

/*--------------  DIB header Marker Define ------------------------*/

#define DIB_HEADER_MARKER   ((WORD) ('M' << 8) | 'B')

/*--------------  typedef's ---------------------------------------*/

typedef BYTE _huge * HPBYTE;

typedef struct
  {
  char  szName[13];
  char  szType[15];
  DWORD cbWidth;
  DWORD cbHeight;
  DWORD cbColors;
  char  szCompress[5];
  }  INFOSTRUCT, FAR * LPINFOSTRUCT;

typedef WORD (CALLBACK* FARHOOK)(HWND,UINT,WPARAM,LPARAM);

/*--------------  Function Prototypes -----------------------------*/

HGLOBAL         ReadDIBFile     (LPCSTR szFile);
HGLOBAL         LoadBM2         (LPCSTR szFile, PALETTEENTRY *pe1, PALETTEENTRY *pe2);
HGLOBAL         LoadBMP         (LPCSTR szFile, PALETTEENTRY *pe16);
BOOL            GetFileName     (LPSTR szFileName, WORD wID);
BOOL            WriteDIBFile    (LPCSTR szFile, HGLOBAL hdib);
BOOL FAR PASCAL InfoDlgProc     (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL FileOpenHookProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);

#endif // __FILE_H__
