//****************************************************************************
// File: fade.c
//
// Purpose: Contains main message loop and application entry point
//
// Functions:
//    WinMain() - initializes everything and enters message loop
//    InitApplication() - registers the window class for first instance of app
//    InitInstance() - creates and displays main window
//
// Development Team:
//
//
// Written by Microsoft Product Support Services, Windows Developer Support
// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.
//
//****************************************************************************

// The following #define is used by GLOBAL.H -- it tells it that we
// want the globals _declared_ in this module.
#define IN_INIT

// Default string length.
#define STR_LEN   50

#include <windows.h>
#include "global.h"
#include "mainwnd.h"

// Global variables local to this file.
static HACCEL hAccTable;

// Local function prototypes.
int  PASCAL WinMain  (HINSTANCE, HINSTANCE, LPSTR, int);
BOOL InitApplication (HINSTANCE hInst);
BOOL InitInstance    (HINSTANCE hInstance, int nCmdShow);

//***********************************************************************
// Function: WinMain
//
// Purpose: Called by Windows on app startup.  Initializes everything,
//          and enters a message loop.
//
// Parameters:
//    hInstance     == Handle to _this_ instance.
//    hPrevInstance == Handle to last instance of app.
//    lpCmdLine     == Command Line passed into app.
//    nCmdShow      == How app should come up (i.e. minimized/normal)
//
// Returns: Return value from PostQuitMessage.
//
// Comments:
//
// History:  Date       Author        Reason
//           1/27/92                  Created
//****************************************************************************

int PASCAL WinMain (HINSTANCE hInstance,  // This instance
                    HINSTANCE hPrevInstance,                  // Last instance
                    LPSTR lpCmdLine,   // Command Line
                    int nCmdShow)      // Minimized or Normal?
{
  MSG msg;

  if (!hPrevInstance)
    if (!InitApplication(hInstance))
      return (FALSE);

  if (!InitInstance(hInstance, nCmdShow))
    return (FALSE);

  while (GetMessage(&msg,             // Put Message Here
                    NULL,             // Handle of window receiving msg
                    NULL,             // lowest message to examine
                    NULL))            // highest message to examine
    {
    if (!TranslateAccelerator(ghWnd, hAccTable, &msg))
      {
      TranslateMessage(&msg);         // Translates virtual key codes
      DispatchMessage(&msg);          // Dispatches message to window
      }
    }

  return (msg.wParam);                // Returns the value from PostQuitMessage
}

//****************************************************************************
// Function: InitApplication
//
// Purpose: Called by WinMain on first instance of app.  Registers
//          the window class.
//
// Parameters:
//    hInst == Handle to _this_ instance.
//
// Returns: TRUE on success, FALSE otherwise.
//
// Comments:
//
// History:  Date       Author        Reason
//           1/27/92                  Created
//****************************************************************************

BOOL InitApplication (HINSTANCE hInst)
{
  WNDCLASS wc;
  char szMenuName[STR_LEN];
  char szClassName[STR_LEN];

  HDC hdc = GetDC(NULL);

  // Are we using a palette device?
  if ((GetDeviceCaps(hdc, RASTERCAPS) & RC_PALETTE) && (GetDeviceCaps(hdc, SIZEPALETTE) >= 256))
    {
    ReleaseDC(NULL, hdc);

    LoadString(hInst, IDS_MAINMENUNAME, szMenuName, STR_LEN);
    LoadString(hInst, IDS_MAINCLASSNAME, szClassName, STR_LEN);

    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon(hInst, "FadeIcon");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
    wc.lpszMenuName = szMenuName;
    wc.lpszClassName = szClassName;

    // Register the window class and return success/failure code.

    return RegisterClass(&wc);
    }
  else
    {
    ReleaseDC(NULL, hdc);
    MessageBox(GetFocus(), "Fade requires a 256-color, palettized display to run!", "Fade Error", MB_ICONSTOP|MB_OK);
    return FALSE;
    }
}

//****************************************************************************
// Function: InitInstance
//
// Purpose: Called by WinMain on instance startup.  Creates and
//            displays the main, overlapped window.
//
// Parameters:
//    hInstance     == Handle to _this_ instance.
//    nCmdShow      == How app should come up (i.e. minimized/normal)
//
// Returns: TRUE on success, FALSE otherwise.
//
// Comments:
//
// History:  Date       Author        Reason
//           1/27/92                  Created
//****************************************************************************

BOOL InitInstance (HINSTANCE hInstance,
                   int nCmdShow)
{
  HWND hWnd;
  char szTitle[STR_LEN];
  char szClassName[STR_LEN];

  // Load some necessary strings from the string table.

  LoadString(hInstance, IDS_APPNAME, szTitle, STR_LEN);
  LoadString(hInstance, IDS_MAINCLASSNAME, szClassName, STR_LEN);

  // Load the accelerator table.

  hAccTable = LoadAccelerators(hInstance, "FadeAccel");

  // Save the instance handle in global variable, which will be used in
  // many subsequence calls from this application to Windows.          

  ghInst = hInstance;

  // Create a main window for this application instance.

  hWnd = CreateWindow(szClassName,    // See RegisterClass() call.
                      szTitle,        // Text for window title bar.
                      WS_OVERLAPPEDWINDOW | WS_VSCROLL,  // Window style.
                      CW_USEDEFAULT,  // Default horizontal position.
                      CW_USEDEFAULT,  // Default vertical position.
                      CW_USEDEFAULT,  // Default width.
                      CW_USEDEFAULT,  // Default height.
                      NULL,           // Overlapped windows have no parent.
                      NULL,           // Use the window class menu.        
                      hInstance,      // This instance owns this window.   
                      NULL);          // Pointer not used.               


  // We'll keep a global of the main window's handle.  This is useful
  //  for calls to MessageBox(), etc.

  ghWnd = hWnd;


  // If window could not be created, return "failure"

  if (!hWnd)
     return (FALSE);


  // Make the window visible; update its client area; and return "success"

  ShowWindow(hWnd, nCmdShow);         // Show the window                        
  UpdateWindow(hWnd);                 // Sends WM_PAINT message

  return TRUE;
}
