
#line 2 "expr.y"
/*  expr.y  -	An expression Evluator. */
#include <iostream.h>
#include <stdio.h>
#include <ctype.h>
#include <assoc.h>
#include <dict.h>
#include <strng.h>
#include <object.h>
#include <math.h>

#define MAXLINESZ  4072
#define MAXTOKENSZ 50

void yyerror(char *) ;
extern int yyparse ()	    ;
extern int yylex()	    ;
int nc = 0 ;
int yyerrorflg	= 0	    ;
istream& yyin	= cin	    ;

Dictionary  SymbolTable     ;

enum SymType  { Ident , Lit, Oper } ;

// base class for Symbol
class Symbol : public Object {

    protected:
    SymType	type;
    int 	hvalue;

    public:
    hashValueType   hashValue() const	{   return (hashValueType) 0 ;	} ;
    classType	    isA()	const	{   return __firstUserClass  ;	} ;
    char    _FAR   *nameOf()	const	{   return "Symbol" ;	 } ;
    SymType	    Stype()	const	{   return type;	 } ;
    virtual float   Svalue()	const = 0 ;
    virtual int     isOper()	const = 0 ;

    ~Symbol()				{} ;

};

// Identifier class sub-class for Symbol
class Identifier  :  public  Symbol {

    String  *name	;	    // name of Identifier
    float   value	;	    // value stored in this var

    public:
    int     isEqual( const Object _FAR & o )	const	{
				    return *(((Identifier&)o).name) == *name ; };
    void    printOn( ostream _FAR & os) 	const	{
				    os << value ;
				    };
    float   Svalue ()		    const   {	return value ;		};
    int     isOper ()		    const   {	return 0 ;		};

    Identifier ( char *sname )	{

	    name    = new String(sname) ;
	    Symbol::type = Ident ;
	    value   = (float) 0  ;
    };

    ~Identifier ()		{
	    delete name ;
    };

    Identifier& Assign( Symbol& sSym )	{
				    value   = sSym.Svalue() ;
				    return  *this ;
				    };
    Identifier& Assign(float	val  )	{
				    value   = val ;
				    return  *this ;
				    };
    void	PrintName(ostream& ost) const	{
				    ost << *name ;
				    };

};

// Literal class sub-class for Symbol
class Literal :  public Symbol {

    float	value	;
    public:
    int 	isEqual(const Object _FAR & o)	const	{
				    return ((Literal &) o).value == value ;
				    };

    void	printOn(ostream _FAR & ost)	const {  ost << value ; } ;
    float	Svalue()	    const   {  return value ; } ;
    int 	isOper()	    const   {  return 0 ;     } ;

    Literal	(float	f)	    {
				    value = f ;
				    Symbol::type = Lit ;
				    };

};

// Operator class sub-class for Symbol
class Operator	: public  Symbol  {

    int     Optype  ;	    // operator

    public:
    int     isEqual(const Object _FAR & o)  const   {
				    return ((Operator &)o).Optype == Optype ;
				};
    void    printOn(ostream _FAR & ost)     const {
				    ost << Optype ;
				};
    float   Svalue()		const	{
				    cerr << "Invalid call to Svalue()\n";
				    return (float) 0 ;
				};
    int     isOper()		const	{   return Optype ;  } ;

    Operator( int Op )		{
				    Optype = Op ;
				    Symbol::type = Oper ;
				};

};

// expression tree
struct	 ExprTree    {
    Symbol	*TNode	;	// this node
    ExprTree	*Ltree	;	// Left Tree
    ExprTree	*Rtree	;	// right Tree
};

extern float	EvalTree(ExprTree *) ;
extern float	CallFunc(Symbol *, float) ;


#line 153 "expr.y"

typedef union  {
    char	yyint	 ;
    Symbol     *yysym	 ;
    ExprTree   *yyEtree  ;
} YYSTYPE;
#define EQUAL 257
#define BO 258
#define BC 259
#define FUNCTION 260
#define BAND 261
#define BOR 262
#define BXOR 263
#define LSH 264
#define RSH 265
#define MOD 266
#define POWER 267
#define STAR 268
#define SLASH 269
#define PLUS 270
#define MINUS 271
#define IDENTIFIER 272
#define NEWLINE 273
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval;
YYSTYPE yyval;
typedef int YYTABELEM;
#define YYERRCODE 256

#line 310 "expr.y"



// Expression Tree evaluator
float	EvalTree   ( ExprTree *Etree ) {

    Symbol *CurrSym ;
    float   lvalue  , rvalue ;

    if (yyerrorflg) {
	cerr << "Error detected in expression; Evaluation terminated\n" ;
	return (float) 0;
    }

    // if not operator then return value
    if (!Etree->TNode->isOper()) {
	CurrSym = Etree->TNode	 ;
	delete	Etree		 ;  // delete this node
	return CurrSym->Svalue() ;
    }

    // if operator then do as required
    switch (Etree->TNode->isOper()) {
    case PLUS :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ( lvalue + rvalue ) ;
    case MINUS :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ( lvalue - rvalue ) ;
    case STAR :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ( lvalue * rvalue ) ;
    case SLASH :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ( lvalue / rvalue ) ;
    case MOD :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ((float) ((int) lvalue % (int)rvalue) ) ;
    case LSH :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ((float)((int) lvalue << (int) rvalue) ) ;
    case RSH :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ((float)((int) lvalue >> (int) rvalue) ) ;
    case BOR :
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ((float)((int) lvalue | (int) rvalue) ) ;
    case BAND:
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ((float)((int) lvalue & (int) rvalue) ) ;
    case POWER:
	lvalue = EvalTree(Etree->Ltree) ;
	rvalue = EvalTree(Etree->Rtree) ;
	delete	Etree ;
	return	 ((float) pow((double) lvalue,(double) rvalue));
    case EQUAL:
	rvalue = EvalTree(Etree->Rtree) ;
	CurrSym = Etree->Ltree->TNode ;
	((Identifier *)CurrSym)->Assign(rvalue) ;
	delete Etree ;
	return(CurrSym->Svalue()) ;
    case FUNCTION:
	rvalue = EvalTree(Etree->Rtree) ;
	CurrSym = Etree->Ltree->TNode	;
	delete Etree ;
	return(CallFunc(CurrSym,rvalue)) ;
    default:
	cerr << "Unrecognized Operator\n" ;
	return (float) 0 ;
    }
}

Symbol	*SymLookUp( char *sid ) {

	String	*sname	=   new String(sid) ;
	Association& tassoc = SymbolTable.lookup(*sname) ;
	if (tassoc == NOOBJECT) {
	    Identifier	*tIdent = new Identifier(sid) ;
	    Association *ttassoc= new Association(*sname, *tIdent) ;
	    SymbolTable.add(*ttassoc) ;
	    return (tIdent) ;
	}

	return ((Symbol*) &tassoc.value()) ;
}


// the lexical analyser
int yylex()	{

    static  char  buffer[MAXLINESZ]  ;
    static  char *pbuff = (char *) 0 ;
    char	  yytext[MAXTOKENSZ];
    char	 *pyytext = yytext   ;
    int     tint   ;
    float   tfloat ;
    int     tdotf  = 0 ;

    _yytop :

    // if buffer is empty fill it up
    if (pbuff == (char *) 0 || *pbuff == '\0') {
	char *tpbuff ;
	pbuff = buffer ;

	__readline:
	while ((*pbuff = yyin.get()) != '\n' && (!yyin.eof()))
		 pbuff++ ;
	// eof has been reached
	if ( yyin.eof() && (pbuff == buffer))
	    return -1 ;
	// put newline & delimiter
	*pbuff	 = '\n'; pbuff++ ;
	*pbuff	 = '\0';

	// check if line continuation exists

	tpbuff = strchr(buffer,'\n') ;
	while (isspace(*tpbuff)) tpbuff-- ;
	// if '\\' then continuation exists
	if (*tpbuff == '\\') {
	    pbuff = tpbuff ;
	    goto __readline ;
	}
	pbuff = buffer ;
    } // buffer fill done.

    // skip thru white space
    while ((*pbuff == '\t') || (*pbuff == ' ')) pbuff++ ;

    // check if any operator
    switch (*pbuff) {
    case '+' :
	pbuff++ ;
	return(PLUS) ;
    case '-' :
	pbuff++ ;
	return(MINUS) ;
    case '*' :
	pbuff++ ;
	return(STAR)  ;
    case '/' :
	pbuff++ ;
	return(SLASH) ;
    case '&' :
	pbuff++ ;
	return(BAND) ;
    case '|' :
	pbuff++ ;
	return(BOR) ;
    case '^' :
	pbuff++     ;
	return(POWER);
    case '~' :
	pbuff++     ;
	return(BXOR);
    case '=' :
	pbuff++     ;
	return(EQUAL) ;
    case '%' :
	pbuff++     ;
	return(MOD) ;
    case '(' :
	pbuff++     ;
	return(BO)  ;
    case ')' :
	pbuff++     ;
	return(BC)  ;
    case '>' :
	pbuff++     ;
	if (*pbuff == '>') {
	    pbuff++ ;
	    return(RSH) ;
	} else cerr << "Error '>'\n" ;
	break ;
    case '<' :
	pbuff++     ;
	if (*pbuff == '<') {
	    pbuff++ ;
	    return (LSH) ;
	} else cerr << "Error '<'\n" ;
	break ;
    case '\n' :
	pbuff++ ;
	return(NEWLINE) ;
    }

    // check if hexadecimal literal
    if ( (*pbuff == '0') && (*(pbuff+1) == 'x') ) {

	// copy over 0x
	*pyytext++ = *pbuff++ ;
	*pyytext++ = *pbuff++ ;
	while (isxdigit(*pbuff)) *pyytext++ = *pbuff++ ;
	*pyytext = '\0' ;

	sscanf(yytext,"%x",&tint) ;
	Literal *tLit = new Literal((float) tint);
	yylval.yysym = tLit ;
	return(IDENTIFIER) ;
    }

    // check if numeric literal
    if (isdigit(*pbuff) || (*pbuff == '.')) {

	while (isdigit(*pbuff) || (*pbuff == '.')) {
	    if (*pbuff == '.' ) {
		if (tdotf)  break ;
		else	    tdotf = 1 ;
	    }
	    *pyytext++ = *pbuff++ ;
	}
	*pyytext = '\0' ;
	sscanf(yytext,"%f",&tfloat) ;
	Literal *tLit = new Literal(tfloat) ;
	yylval.yysym = tLit ;
	return (IDENTIFIER) ;
    }

    // check for identifier
    if (isalpha(*pbuff)) {
	while (isalpha(*pbuff) || isdigit(*pbuff))
	    *pyytext++ = *pbuff++ ;
	*pyytext = '\0' ;
	yylval.yysym = SymLookUp(yytext);
	return(IDENTIFIER) ;
    }

    // tell world about unknown character then
    // carry on as if nothing happened.

    cerr << "Unrecognized character '" << *pbuff << "'\n" ;
    pbuff++ ;
    goto _yytop ;
}

Operator *Equal    = new Operator (EQUAL) ;
Operator *Function = new Operator (FUNCTION) ;
Operator *Band	   = new Operator (BAND)  ;
Operator *Bor	   = new Operator (BOR)   ;
Operator *Bxor	   = new Operator (BXOR)  ;
Operator *Lsh	   = new Operator (LSH)   ;
Operator *Rsh	   = new Operator (RSH)   ;
Operator *Mod	   = new Operator (MOD)   ;
Operator *Power    = new Operator (POWER) ;
Operator *Star	   = new Operator (STAR)  ;
Operator *Slash    = new Operator (SLASH) ;
Operator *Plus	   = new Operator (PLUS)  ;
Operator *Minus    = new Operator (MINUS) ;

struct FuncAssc  {
    double (*Func) (double) ;
    Symbol  *Fsym	    ;
}   FuncTbl[]	=   {
    sin  , SymLookUp("sin") ,
    cos  , SymLookUp("cos") ,
    fabs , SymLookUp("abs") ,
    tan  , SymLookUp("tan") ,
    acos , SymLookUp("acos"),
    asin , SymLookUp("asin"),
    atan , SymLookUp("atan"),
    log  , SymLookUp("log") ,
    log10, SymLookUp("log10")
};

#define FTBLSZ	9

float	CallFunc    ( Symbol *Fname, float parm ) {

    for ( int i = 0 ; i < FTBLSZ ; i++ ) {
	if ( *FuncTbl[i].Fsym == *Fname )
	    return ((float) (*FuncTbl[i].Func)((double)parm)) ;
    }

    cerr << "Udefined function '" ;
    ((Identifier *) Fname)->PrintName(cerr) ;
    cerr << "'\n" ;
    return (float) 0 ;
}

void yyerror (char *s) {
    yyerrorflg = 1 ;
    printf(s) ;
}

void main() {
    printf("[%d] ",nc) ;
    while(yyparse()) ;
}
static YYTABELEM yyexca[] = {
    -1,     1,
     0,    -1,
    -2,     0,
};

#define YYNPROD 30
#define YYLAST 60
static const YYTABELEM yyact[60] = {
    17,    19,    17,    22,    23,    25,    24,    29,    27,    28,
    31,    30,    26,    47,     5,     4,    33,    46,    20,    21,
    21,    15,    13,    14,    10,     6,    12,     2,    11,    18,
     1,     9,    16,     8,     3,     7,     0,     0,     0,     0,
     0,     0,     0,    32,     0,     0,    34,    35,    36,     0,
     0,    40,    43,    45,    44,    42,    41,    39,    38,    37
};

static const YYTABELEM yypact[48] = {
  -258,  -258, -1000,  -272, -1000,  -239, -1000,  -268,  -266,  -262,
  -264,  -249,  -254,  -257,  -260,  -253,  -255,  -256, -1000, -1000,
  -256,  -256,  -256,  -256,  -256,  -256,  -256,  -256,  -256,  -256,
  -256,  -256,  -242,  -238, -1000,  -246, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000
};

static const YYTABELEM yypgo[15] = {
     0,    34,    25,    35,    33,    31,    24,    28,    26,    22,
    23,    21,    32,    30,    27
};

static const YYTABELEM yyr1[30] = {
     0,    13,    13,    14,    14,     1,     1,     2,     2,     3,
     3,     4,     4,     5,     5,     6,     6,     7,     7,     8,
     8,     9,     9,    10,    10,    11,    11,    12,    12,    12
};

static const YYTABELEM yyr2[30] = {
     0,     1,     2,     2,     1,     3,     1,     3,     1,     3,
     1,     3,     1,     3,     1,     3,     1,     3,     1,     3,
     1,     3,     1,     3,     1,     3,     1,     1,     4,     3
};

static const YYTABELEM yychk[48] = {
 -1000,   -13,   -14,    -1,   273,   272,    -2,    -3,    -4,    -5,
    -6,    -7,    -8,    -9,   -10,   -11,   -12,   258,   -14,   273,
   257,   258,   271,   270,   268,   269,   261,   262,   266,   267,
   264,   265,    -2,   272,    -2,    -2,    -2,    -3,    -4,    -5,
    -6,    -7,    -8,    -9,   -10,   -11,   259,   259
};

static const YYTABELEM yydef[48] = {
     0,    -2,     1,     0,     4,    27,     6,     8,    10,    12,
    14,    16,    18,    20,    22,    24,    26,     0,     2,     3,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    27,     5,     0,     7,     9,    11,    13,
    15,    17,    19,    21,    23,    25,    29,    28
};

/*----------------------------------------------------------------------------
 * This is a parser generated by JQYACC, using file YACC.SKE
 * by John Q. Walker II (JOHNQ at RALVM6), September 15, 1991
 *--------------------------------------------------------------------------*/

#define YACC_PARSER

#ifdef YYDEBUG
    #ifndef YYDEBUG_DECLARED
        #define YYDEBUG_DECLARED
        static int yydebug = 1;   /* set this to 1 when you are debugging */
        #define YY_D(x)           if(yydebug) {x;} else
    #endif
#else
    #define YY_D(x)
#endif

#define YYFLAG   (-1000)
#define YYERROR  goto yyerrlab
#define YYACCEPT return(0)
#define YYABORT  return(1)

/* Global variables used by the parser */

YYSTYPE yyv[YYMAXDEPTH];        /* value stack */
YYSTYPE *yypv;                  /* top of value stack */
YYSTYPE *yypvt;                 /* $n: top of value stack for $vars */

YYTABELEM yys[YYMAXDEPTH];      /* state stack */
YYTABELEM *yyps;                /* top of state stack */
YYTABELEM yystate;              /* current state */

int yynerrs;                    /* number of errors */
int yyerrflag;                  /* error recovery flag */
int yychar;                     /* current input token nbr, 0 means EOF */


/* Parser for YACC output */
int yyparse(void) {

    YYTABELEM yyj;              /* temporary variable */
    YYTABELEM yym;              /* temporary variable: current production */
    YYTABELEM yyn;              /* temporary variable: production */
    YYTABELEM *yyxi;            /* index through exception table */


    /* Initialize externals - yyparse may be called more than once */
    yystate   = 0;              /* the initial state is zero */
    yynerrs   = 0;              /* no errors yet */
    yyerrflag = 0;              /* error recovery flag, initial setting */
    yychar    = -1;             /* when < 0, get another; when 0, EOF */
    yyps      = &yys[-1];       /* point before the first state element */
    yypv      = &yyv[-1];       /* point before the first value element */

yystack:                        /* put a state & value onto the stack */

    YY_D( printf("state %d, char %c (%#2.2x)\n", yystate, yychar, yychar) );

    if (++yyps < &yys[YYMAXDEPTH]) {
        *yyps = yystate;        /* save the current state at the top */
        ++yypv;                 /* move to the next value stack position */
        *yypv = yyval;          /* save the current value at the top */
    }
    else {
        yyerror("YACC stack overflow; consider increasing \"YYMAXDEPTH\"");
        YYABORT;
    }

yynewstate:

    if ((yyn = yypact[yystate]) > YYFLAG) {
        if (yychar < 0)         /* OK to get another? */
            if ((yychar = yylex()) < 0) /* read from lexical analyzer */
                yychar = 0;     /* EOF reached */
        if (((yyn += yychar) >= 0) && (yyn < YYLAST)) {
            if (yychk[yyn = yyact[yyn]] == yychar) { /* valid shift */
                yychar  = -1;   /* get another lexical analyzer value */
                yyval   = yylval;
                yystate = yyn;
                if (yyerrflag > 0)
                    --yyerrflag;
                goto yystack;   /* put a state & value onto the stack */
            }
        }
    }

    /* default state action */
    if ((yyn = yydef[yystate]) == -2) {
        if (yychar < 0)         /* OK to get another? */
            if ((yychar = yylex()) < 0) /* read from lexical analyzer */
                yychar = 0;     /* EOF reached */

        /* look through the exception table */
        for (yyxi = yyexca; (*yyxi != -1) || (yyxi[1] != yystate); yyxi += 2);
            /* VOID */

        while (*(yyxi += 2) >= 0)
            if (*yyxi == yychar)
                break;
        if ((yyn = yyxi[1]) < 0)
            YYACCEPT;
    }

    if (yyn == 0) {             /* was an error detected? */
        /* error found; attempt to resume parsing */
        switch (yyerrflag) {
            case 0:             /* brand new error */
                yyerror("syntax error");
yyerrlab:
                ++yynerrs;      /* another error encountered */

            case 1:
            case 2:             /* incompletely recovered error, try again */

                yyerrflag = 3;

                /* find a state where "error" is a legal shift action */

                for ( ; (yyps >= yys); yyps--, yypv--) {
                    yyn = yypact[*yyps] + YYERRCODE;
                    if ((yyn >= 0) && (yyn < YYLAST) &&
                        (yychk[yyact[yyn]] == YYERRCODE)) {
                        yystate = yyact[yyn]; /* simulate shift of "error"  */
                        goto yystack; /* put a state & value onto the stack */
                    }
                    yyn = yypact[*yyps];

                    /* the current yyps has no shift on "error", pop stack  */

                    YY_D( printf("error recovery pops state %d, uncovers %d\n",
                          *yyps, yyps[-1]) );
                }

                /* There is no state on the stack with an error shift ... */
                YYABORT;

            case 3:         /* no shift yet; consume an input character */

                YY_D( printf("error recovery discards char %d\n", yychar) );

                if (yychar != 0) {      /* reached EOF? */
                    yychar = -1;        /* get another lex value */
                    goto yynewstate;    /* try again in the same state */
                }
                else YYABORT;           /* EOF reached */
        }  /* end of the switch (yyerrflag) */
    }
    /* reduction by production yyn */

    YY_D( printf("reduce %d\n", (int)yyn) );

    yyps -= yyr2[yyn];
    yypvt = yypv;
    yypv -= yyr2[yyn];
    yyval = yypv[1];

    /* consult goto table to find next state */
    yym   = yyn;
    yyn   = (YYTABELEM)yyr1[yyn];
    yyj   = yypgo[yyn] + *yyps + 1;
    if ((yyj >= YYLAST) || (yychk[yystate = yyact[yyj]] != -yyn))
        yystate = yyact[yypgo[yyn]];

    switch (yym) {
        
case 1:
#line 166 "expr.y"
{ printf ("[%d] ",nc) ;	     } break;
case 2:
#line 167 "expr.y"
{ printf ("[%d] ",nc) ;	     } break;
case 3:
#line 170 "expr.y"
{ nc++ ; cout << EvalTree(yypvt[-1].yyEtree) << "\n"; } break;
case 5:
#line 174 "expr.y"
{
					   if (yypvt[-2].yysym->Stype() != Ident) {
						yyerror("Lvalue required for assign\n");
					   } else {
						ExprTree *Etree = new ExprTree;
						Etree->Ltree	= new ExprTree;
						Etree->Ltree->TNode = yypvt[-2].yysym;
						Etree->TNode	= Equal ;
						Etree->Rtree	= yypvt[-0].yyEtree	;
						yyval.yyEtree   = Etree ;
					   }
					} break;
case 6:
#line 186 "expr.y"
{  yyval.yyEtree	=   yypvt[-0].yyEtree; } break;
case 7:
#line 189 "expr.y"
{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Minus ;
					    Etree->Ltree    = yypvt[-2].yyEtree  ;
					    Etree->Rtree    = yypvt[-0].yyEtree  ;
					    yyval.yyEtree	= Etree 	 ;
					} break;
case 8:
#line 196 "expr.y"
{   yyval.yyEtree	=   yypvt[-0].yyEtree; } break;
case 9:
#line 199 "expr.y"
{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Plus ;
					    Etree->Ltree    = yypvt[-2].yyEtree  ;
					    Etree->Rtree    = yypvt[-0].yyEtree  ;
					    yyval.yyEtree	= Etree 	 ;
					} break;
case 10:
#line 206 "expr.y"
{   yyval.yyEtree	=   yypvt[-0].yyEtree; } break;
case 11:
#line 209 "expr.y"
{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Star ;
					    Etree->Ltree    = yypvt[-2].yyEtree  ;
					    Etree->Rtree    = yypvt[-0].yyEtree  ;
					    yyval.yyEtree	= Etree 	 ;
					} break;
case 12:
#line 216 "expr.y"
{   yyval.yyEtree	=   yypvt[-0].yyEtree; } break;
case 13:
#line 219 "expr.y"
{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Slash ;
					    Etree->Ltree    = yypvt[-2].yyEtree  ;
					    Etree->Rtree    = yypvt[-0].yyEtree  ;
					    yyval.yyEtree	= Etree 	 ;
					} break;
case 14:
#line 226 "expr.y"
{   yyval.yyEtree	=   yypvt[-0].yyEtree; } break;
case 15:
#line 229 "expr.y"
{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Band ;
					    Etree->Ltree    = yypvt[-2].yyEtree  ;
					    Etree->Rtree    = yypvt[-0].yyEtree  ;
					    yyval.yyEtree	= Etree 	 ;
					} break;
case 16:
#line 236 "expr.y"
{   yyval.yyEtree	=   yypvt[-0].yyEtree; } break;
case 17:
#line 239 "expr.y"
{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Bor ;
					    Etree->Ltree    = yypvt[-2].yyEtree  ;
					    Etree->Rtree    = yypvt[-0].yyEtree  ;
					    yyval.yyEtree	= Etree 	 ;
					} break;
case 18:
#line 246 "expr.y"
{   yyval.yyEtree	=   yypvt[-0].yyEtree; } break;
case 19:
#line 249 "expr.y"
{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Mod ;
					    Etree->Ltree    = yypvt[-2].yyEtree  ;
					    Etree->Rtree    = yypvt[-0].yyEtree  ;
					    yyval.yyEtree	= Etree 	 ;
					} break;
case 20:
#line 256 "expr.y"
{   yyval.yyEtree	=   yypvt[-0].yyEtree; } break;
case 21:
#line 259 "expr.y"
{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Power ;
					    Etree->Ltree    = yypvt[-2].yyEtree  ;
					    Etree->Rtree    = yypvt[-0].yyEtree  ;
					    yyval.yyEtree	= Etree 	 ;
					} break;
case 22:
#line 266 "expr.y"
{   yyval.yyEtree	=   yypvt[-0].yyEtree; } break;
case 23:
#line 269 "expr.y"
{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Lsh ;
					    Etree->Ltree    = yypvt[-2].yyEtree  ;
					    Etree->Rtree    = yypvt[-0].yyEtree  ;
					    yyval.yyEtree	= Etree 	 ;
					} break;
case 24:
#line 276 "expr.y"
{   yyval.yyEtree	=   yypvt[-0].yyEtree; } break;
case 25:
#line 279 "expr.y"
{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = Rsh ;
					    Etree->Ltree    = yypvt[-2].yyEtree  ;
					    Etree->Rtree    = yypvt[-0].yyEtree  ;
					    yyval.yyEtree	= Etree 	 ;
					} break;
case 26:
#line 286 "expr.y"
{   yyval.yyEtree	=   yypvt[-0].yyEtree; } break;
case 27:
#line 289 "expr.y"
{
					    ExprTree *Etree = new ExprTree ;
					    Etree->TNode    = yypvt[-0].yysym ;
					    yyval.yyEtree		    = Etree ;
					} break;
case 28:
#line 294 "expr.y"
{
					    if (yypvt[-3].yysym->Stype() != Ident) {
						yyerror("Expected Identifier\n");
					    } else {

						ExprTree *Etree = new ExprTree ;
						Etree->Ltree	= new ExprTree ;
						Etree->TNode	= Function     ;
						Etree->Ltree->TNode = yypvt[-3].yysym;
						Etree->Rtree	= yypvt[-1].yyEtree	       ;
						yyval.yyEtree		= Etree        ;
					    }
					} break;
case 29:
#line 307 "expr.y"
{   yyval.yyEtree = yypvt[-1].yyEtree ;	} break;
    } /* end of switch (yym) */

    goto yystack; /* put a state & value onto the stack */
} /* end of yyparse() */
