#include <owl\dialog.h>
#include <owl\applicat.h>
#include "edialog.h"
TEDialog::TEDialog(TWindow * AParent,TResId resid,TModule* module)
		: TDialog(AParent,resid, module)
		{

			executingMethod = 0;
		 }
//
// Execute always shows the dialogs
//
int TEDialog::Execute(int flags)
	{
		if (!flags)
			return TDialog::Execute();
		if (Create())
			{
				executingMethod = flags;
				if (!(TWindow::Attr.Style & WS_VISIBLE))
					Show(SW_SHOW);
				TWindow * modalWindow;
				if (flags & MB_SYSTEMMODAL)
					modalWindow = this;
				else
					if (flags & MB_TASKMODAL)
						modalWindow = this;
					else
						modalWindow = Parent;  // only the parent will be disabled
				return GetApplication()->BeginModal(modalWindow,flags);
			}
		return -1;
	}
//
// If executing BeginModally, ensure the right method of closing
// is used.
//
void TEDialog::Destroy(int Return)
	{
		if (executingMethod)
			{
				GetApplication()->EndModal(Return);
				executingMethod = 0;
			}
		TDialog::Destroy(Return);
	}

void TEDialog::CloseWindow(int returnValue)
	{
		if (executingMethod) // get my variation
			{
				if (CanClose())
					{
						TransferData(tdGetData);
						Destroy(returnValue);
					}
			}
		else
			TDialog::CloseWindow(returnValue);
	}
